/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import net.objectlab.qalab.parser.BaseStatMerge;
import net.objectlab.qalab.util.FilenameUtil;
import net.objectlab.qalab.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CoberturaLineStatMerge
extends BaseStatMerge {
    private static final String COBERTURA_LINE = "cobertura-line";
    private int totalLineRate = 0;
    private int totalBranchRate = 0;
    private boolean skipCurrentElement = false;

    public String getType() {
        return COBERTURA_LINE;
    }

    protected final String getSummaryTag() {
        return "coverage";
    }

    private Object getFileTag() {
        return "class";
    }

    private String getFileNameAttribute() {
        return "filename";
    }

    public final void startElement(String ignoreNamespaceURI, String localname, String qualifiedname, Attributes attrs) throws SAXException {
        String local = localname;
        if ("".equals(local)) {
            local = qualifiedname;
        }
        if (this.getSummaryTag().equals(local)) {
            String lineRate = Util.getAttributeValue(attrs, "line-rate", this.isQuiet(), this.getTaskLogger());
            String branchRate = Util.getAttributeValue(attrs, "branch-rate", this.isQuiet(), this.getTaskLogger());
            this.totalLineRate = new BigDecimal(lineRate).movePointRight(2).intValue();
            this.totalBranchRate = new BigDecimal(branchRate).movePointRight(2).intValue();
        } else if (this.getFileTag().equals(local)) {
            String className = Util.getAttributeValue(attrs, "name", this.isQuiet(), this.getTaskLogger());
            if (className != null && className.indexOf(36) > 0) {
                this.skipCurrentElement = true;
                return;
            }
            this.resetFileStatistics();
            this.incrementFileCount(1);
            this.setFileName(attrs);
            String lineRate = Util.getAttributeValue(attrs, "line-rate", this.isQuiet(), this.getTaskLogger());
            String branchRate = Util.getAttributeValue(attrs, "branch-rate", this.isQuiet(), this.getTaskLogger());
            if (!this.isQuiet()) {
                this.getTaskLogger().log("lineRate=" + lineRate + " branchRate=" + branchRate);
            }
            if (this.getType().equals(COBERTURA_LINE)) {
                int lineAsPercent = new BigDecimal(lineRate).movePointRight(2).intValue();
                this.addFileStatistics(lineAsPercent);
            } else {
                int lineAsPercent = new BigDecimal(branchRate).movePointRight(2).intValue();
                this.addFileStatistics(lineAsPercent);
            }
        }
    }

    public final void endElement(String ignoreNamespaceURI, String ignoreSimplename, String qualifiedname) throws SAXException {
        if (this.getFileTag().equals(qualifiedname)) {
            if (!this.skipCurrentElement) {
                this.addNewResults();
            } else {
                this.skipCurrentElement = false;
            }
        }
    }

    protected void setFileName(Attributes att) {
        String fileName = Util.getAttributeValue(att, this.getFileNameAttribute(), this.isQuiet(), this.getTaskLogger());
        fileName = FilenameUtil.trimFilename(fileName, this.getSrcDir());
        if (!this.isQuiet()) {
            this.getTaskLogger().log("setCurrentFileName FILE [" + fileName + "] srcDir [" + this.getSrcDir() + "]");
        }
        this.setCurrentFile(fileName);
    }

    public int getTotalStatistics() {
        if (this.getType().equals(COBERTURA_LINE)) {
            return this.totalLineRate;
        }
        return this.totalBranchRate;
    }

    protected InputSource preProcessSource(InputSource source) {
        StringBuffer buf = new StringBuffer();
        InputStream reader = source.getByteStream();
        int i = -1;
        if (reader != null) {
            do {
                try {
                    i = reader.read();
                }
                catch (IOException e) {
                    this.getTaskLogger().log(e.toString());
                }
                buf.append((char)i);
            } while (i >= 0);
        } else {
            Reader rd = source.getCharacterStream();
            do {
                try {
                    i = rd.read();
                }
                catch (IOException e) {
                    this.getTaskLogger().log(e.toString());
                }
                buf.append((char)i);
            } while (i >= 0);
        }
        int idx = buf.indexOf("<coverage");
        if (idx >= 0) {
            buf = buf.delete(0, idx);
        }
        return new InputSource(new StringReader(buf.toString()));
    }
}

