/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import net.objectlab.qalab.util.Util;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildStatForChartParser
extends DefaultHandler {
    private static final int NUM_HOURS_BEFORE_LAST_DATE = -28;
    private static final long ONE_DAY_IN_MS = 86400000L;
    private static final String DEFAULT_SUMMARY_TYPES = "checkstyle,pmd,findbugs,simian";
    private static final String DEFAULT_TYPES = "checkstyle,pmd,findbugs,simian,cobertura-branch,cobertura-line";
    private static final int DEFAULT_FONT_SIZE = 9;
    private static final float ALPHA = 0.7f;
    private static final int MAX_WIDTH = 1000;
    private static final Map COLOURS = new HashMap();
    private static final Map STROKES = new HashMap();
    private TaskLogger parentTask;
    private boolean currentElementisSummary = false;
    private String toDir = "";
    private int chartWidth;
    private int chartHeight;
    private int movingAverage = 0;
    private boolean summaryOnly = true;
    private String currentName;
    private boolean fileStat = false;
    private Map dates = new HashMap();
    private Map errors = new HashMap();
    private List types = Collections.EMPTY_LIST;
    private List summaryTypes = Collections.EMPTY_LIST;
    private Image logo;
    private boolean quiet = true;
    private String filePrefix = "";
    private String xAxisTitle = "Dates";
    private String yAxisTitle = "Violations";
    private String xAxisSummaryTitle = "Dates";
    private String yAxisSummaryTitle = "Violations";
    static /* synthetic */ Class class$org$jfree$data$time$FixedMillisecond;
    static /* synthetic */ Class class$net$objectlab$qalab$parser$BuildStatForChartParser;

    public BuildStatForChartParser(TaskLogger logger) {
        this.parentTask = logger;
        this.setAcceptedStyle(DEFAULT_TYPES);
        this.setSummaryStyle(DEFAULT_SUMMARY_TYPES);
    }

    public final void setAcceptedStyle(String acceptedStyleStr) {
        this.types = Util.listify(acceptedStyleStr, ",");
    }

    public final void setSummaryStyle(String acceptedStyleStr) {
        this.summaryTypes = Util.listify(acceptedStyleStr, ",");
        if (!this.quiet) {
            this.parentTask.log("Summary Styles: " + this.summaryTypes);
        }
    }

    public final void startElement(String ignoreNamespaceURI, String localname, String qualifiedname, Attributes attrs) throws SAXException {
        String local = localname;
        if ("".equals(local)) {
            local = qualifiedname;
        }
        if (!this.currentElementisSummary && "summary".equals(local)) {
            this.currentElementisSummary = true;
            this.currentName = "summary";
        }
        if (!this.currentElementisSummary && !this.fileStat && "file".equals(local)) {
            this.fileStat = true;
            this.currentName = this.getFileName(attrs);
            this.dates.clear();
            this.errors.clear();
        }
        if (this.currentElementisSummary) {
            this.processSummaryResult(local, attrs);
        } else if (!this.isSummaryOnly() && this.fileStat) {
            this.processFileResult(local, attrs);
        }
    }

    private void processFileResult(String local, Attributes attrs) {
        if (!"result".equals(local)) {
            return;
        }
        this.processResult(attrs);
    }

    private void add(Map map, String type, Object val) {
        if (val == null) {
            return;
        }
        ArrayList<Object> list = (ArrayList<Object>)map.get(type);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(type, list);
        }
        list.add(val);
    }

    private String getFileName(Attributes attrs) {
        String fileName = null;
        int attrCount = attrs.getLength();
        for (int i = 0; i < attrCount; ++i) {
            String attribute = attrs.getQName(i);
            if (!"id".equals(attribute)) continue;
            fileName = attrs.getValue(i).replace('/', '_');
            break;
        }
        return fileName;
    }

    private void processSummaryResult(String local, Attributes attrs) {
        if (!"summaryresult".equals(local)) {
            return;
        }
        this.processResult(attrs);
    }

    private void processResult(Attributes attrs) {
        int attrCount = attrs.getLength();
        Date date = null;
        boolean accepted = false;
        Integer error = null;
        String type = null;
        for (int i = 0; i < attrCount; ++i) {
            String attribute = attrs.getQName(i);
            String value = attrs.getValue(i);
            if ("type".equals(attribute)) {
                type = value;
                if (this.currentElementisSummary) {
                    if (!this.quiet) {
                        this.parentTask.log("Check that the summary " + value + " is accepted in " + this.summaryTypes);
                    }
                    accepted = this.summaryTypes.contains(value);
                    continue;
                }
                accepted = this.types.contains(value);
                continue;
            }
            if ("statvalue".equals(attribute)) {
                error = Integer.valueOf(value);
                continue;
            }
            if (!"date".equals(attribute)) continue;
            try {
                if (value != null && value.length() > 10) {
                    date = QALabTags.DEFAULT_DATETIME_FORMAT.parse(value);
                    continue;
                }
                if (value != null && value.length() == 10) {
                    date = QALabTags.DEFAULT_DATE_FORMAT.parse(value);
                    continue;
                }
                throw new IllegalArgumentException("OUCH -> date size = " + (value != null ? value.length() : 0) + " [" + value + "]");
            }
            catch (ParseException e) {
                this.parentTask.log(e.getMessage());
            }
        }
        if (accepted) {
            this.add(this.dates, type, date);
            this.add(this.errors, type, error);
        }
    }

    public final void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public final void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public final void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
    }

    private void printError(String errorType, SAXParseException ex) {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(errorType).append("] ");
        if (ex == null) {
            buf.append("!!!");
        }
        if (ex != null) {
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                buf.append(systemId);
            }
            buf.append(':');
            buf.append(ex.getLineNumber());
            buf.append(':');
            buf.append(ex.getColumnNumber());
            buf.append(": ");
            buf.append(ex.getMessage());
        }
        this.parentTask.log(buf.toString());
    }

    public final void endElement(String ignoreNamespaceURI, String localName, String qualifiedname) throws SAXException {
        String local = localName;
        if ("".equals(local)) {
            local = qualifiedname;
        }
        if (this.currentElementisSummary && "summary".equals(local)) {
            this.currentElementisSummary = false;
            if (!this.quiet) {
                this.parentTask.log("Summary Found Dates:" + this.dates + " / errors " + this.errors);
            }
            this.chart("summary", this.dates, this.errors, true, true);
        } else if (!this.isSummaryOnly() && this.fileStat && "file".equals(local)) {
            this.fileStat = false;
            if (!this.quiet) {
                this.parentTask.log("Found " + this.currentName + " Dates:" + this.dates + " / errors " + this.errors);
            }
            this.chart(this.currentName, this.dates, this.errors, false, false);
        }
    }

    private void chart(String name, Map theDates, Map theErrors, boolean withAverage, boolean summaryChart) {
        try {
            if (theDates.size() == 0) {
                return;
            }
            ArrayList availableTypes = new ArrayList();
            TimeSeriesCollection series = new TimeSeriesCollection();
            this.buildTimeSeries(theDates, theErrors, withAverage, availableTypes, series);
            StringBuffer existingTypes = new StringBuffer();
            Iterator it = availableTypes.iterator();
            while (it.hasNext()) {
                existingTypes.append(it.next()).append(" ");
            }
            String title = existingTypes.toString() + " Stats " + name;
            String yTitle = this.getYAxisTitle();
            String xTitle = this.getXAxisTitle();
            if (summaryChart) {
                yTitle = this.getYAxisSummaryTitle();
                xTitle = this.getXAxisSummaryTitle();
            }
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)xTitle, (String)yTitle, (XYDataset)series, (boolean)true, (boolean)false, (boolean)false);
            TextTitle copyright = new TextTitle("QALab 2004+,ObjectLab.co.uk Generated " + QALabTags.DEFAULT_DATETIME_FORMAT.format(new Date()), new Font("SansSerif", 0, 9));
            copyright.setPosition(RectangleEdge.BOTTOM);
            copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
            chart.addSubtitle((Title)copyright);
            chart.setBackgroundImage(this.getLogo());
            chart.setBackgroundImageAlpha(0.7f);
            chart.setBackgroundImageAlignment(6);
            chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            XYPlot xyPlot = chart.getXYPlot();
            XYItemRenderer renderer = xyPlot.getRenderer();
            if (!withAverage && renderer instanceof StandardXYItemRenderer) {
                StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
                rr.setPlotImages(true);
                rr.setShapesFilled(Boolean.TRUE);
            }
            int index = 0;
            Iterator it2 = availableTypes.iterator();
            while (it2.hasNext()) {
                String type = (String)it2.next();
                renderer.setSeriesPaint(index, (Paint)COLOURS.get(type));
                Stroke stroke = (Stroke)STROKES.get(type);
                if (stroke != null) {
                    renderer.setSeriesStroke(index, stroke);
                }
                ++index;
            }
            DateAxis axis = (DateAxis)xyPlot.getDomainAxis();
            axis.setVerticalTickLabels(true);
            File file2 = new File(this.getToDir() + this.getFilePrefix() + name + ".png");
            ChartUtilities.saveChartAsPNG((File)file2, (JFreeChart)chart, (int)this.getChartWidth(), (int)this.getChartHeight());
        }
        catch (IOException e) {
            this.parentTask.log(e.toString());
        }
    }

    private void buildTimeSeries(Map theDates, Map theErrors, boolean withAverage, List availableTypes, TimeSeriesCollection series) {
        Iterator typeIter = theDates.entrySet().iterator();
        Date max = this.findMaxDate(theDates);
        Calendar cal = Calendar.getInstance();
        cal.setTime(max);
        cal.add(11, -28);
        Date zeroDeadline = cal.getTime();
        while (typeIter.hasNext()) {
            Map.Entry pairTypeDates = typeIter.next();
            String type = (String)pairTypeDates.getKey();
            availableTypes.add(type);
            TimeSeries ts = new TimeSeries(type, "bla", "bli", class$org$jfree$data$time$FixedMillisecond == null ? BuildStatForChartParser.class$("org.jfree.data.time.FixedMillisecond") : class$org$jfree$data$time$FixedMillisecond);
            List typeDates = (List)pairTypeDates.getValue();
            List typeErrors = (List)theErrors.get(type);
            if (typeDates != null && typeErrors != null) {
                this.addDataToTimeSeries(zeroDeadline, ts, typeDates, typeErrors);
            }
            series.addSeries(ts);
            if (!withAverage || this.getMovingAverage() <= 0) continue;
            series.addSeries(MovingAverage.createPointMovingAverage((TimeSeries)ts, (String)(type + " " + this.getMovingAverage() + "-run Moving Average"), (int)this.getMovingAverage()));
        }
    }

    private void addDataToTimeSeries(Date zeroDeadline, TimeSeries ts, List typeDates, List typeErrors) {
        Iterator dateIter = typeDates.iterator();
        Iterator errorsIter = typeErrors.iterator();
        Date lastDateForThisType = null;
        while (dateIter.hasNext() && errorsIter.hasNext()) {
            lastDateForThisType = (Date)dateIter.next();
            Integer count = (Integer)errorsIter.next();
            ts.addOrUpdate((RegularTimePeriod)new FixedMillisecond(lastDateForThisType), (Number)count);
        }
        if (lastDateForThisType != null && zeroDeadline != null && zeroDeadline.after(lastDateForThisType)) {
            ts.addOrUpdate((RegularTimePeriod)new FixedMillisecond(lastDateForThisType.getTime() + 86400000L), 0.0);
        }
    }

    private Date findMaxDate(Map theDates) {
        Date maxDate = null;
        Iterator typeIter = theDates.entrySet().iterator();
        while (typeIter.hasNext()) {
            Map.Entry pairTypeDates = typeIter.next();
            List typeDates = (List)pairTypeDates.getValue();
            if (typeDates == null) continue;
            Iterator it = typeDates.iterator();
            while (it.hasNext()) {
                Date date = (Date)it.next();
                if (maxDate != null) {
                    maxDate = maxDate.before(date) ? date : maxDate;
                    continue;
                }
                maxDate = date;
            }
        }
        return maxDate;
    }

    public String getYAxisSummaryTitle() {
        return this.yAxisSummaryTitle;
    }

    public void setYAxisSummaryTitle(String axisSummaryTitle) {
        this.yAxisSummaryTitle = axisSummaryTitle;
    }

    private Image getLogo() {
        if (this.logo == null) {
            URL url = (class$net$objectlab$qalab$parser$BuildStatForChartParser == null ? (class$net$objectlab$qalab$parser$BuildStatForChartParser = BuildStatForChartParser.class$("net.objectlab.qalab.parser.BuildStatForChartParser")) : class$net$objectlab$qalab$parser$BuildStatForChartParser).getResource("/net/objectlab/qalab/objectlab.gif");
            ImageIcon temp = new ImageIcon(url);
            this.logo = temp.getImage();
        }
        return this.logo;
    }

    public final int getChartWidth() {
        return this.chartWidth;
    }

    public final void setChartWidth(int width) {
        this.chartWidth = width;
    }

    public final int getChartHeight() {
        return this.chartHeight;
    }

    public final void setChartHeight(int height) {
        this.chartHeight = height;
    }

    public final String getToDir() {
        return this.toDir;
    }

    public final void setToDir(String outputDirectory) {
        this.toDir = outputDirectory;
    }

    public final int getMovingAverage() {
        return this.movingAverage;
    }

    public final void setMovingAverage(int average) {
        this.movingAverage = average;
    }

    public String getXAxisSummaryTitle() {
        return this.xAxisSummaryTitle;
    }

    public void setXAxisSummaryTitle(String axisSummaryTitle) {
        this.xAxisSummaryTitle = axisSummaryTitle;
    }

    public final boolean isSummaryOnly() {
        return this.summaryOnly;
    }

    public final void setSummaryOnly(boolean summary) {
        this.summaryOnly = summary;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean noLog) {
        this.quiet = noLog;
    }

    public String getFilePrefix() {
        if (this.filePrefix == null) {
            return "";
        }
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public void setXAxisTitle(String axisTitle) {
        this.xAxisTitle = axisTitle;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public void setYAxisTitle(String axisTitle) {
        this.yAxisTitle = axisTitle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        COLOURS.put("findbugs", ChartColor.RED);
        COLOURS.put("pmd", new Color(85, 85, 255));
        COLOURS.put("checkstyle", new Color(85, 255, 85));
        COLOURS.put("pmd-cpd", new Color(255, 85, 255));
        COLOURS.put("simian", ChartColor.GRAY);
        COLOURS.put("cobertura-line", ChartColor.PINK);
        COLOURS.put("cobertura-branch", ChartColor.DARK_CYAN);
        STROKES.put("checkstyle", new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
        STROKES.put("findbugs", new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 3.0f}, 1.0f));
        STROKES.put("cobertura-branch", new BasicStroke(2.0f, 1, 2));
        STROKES.put("cobertura-line", new BasicStroke(2.0f, 1, 2));
        STROKES.put("simian", new BasicStroke(2.0f, 1, 2));
        STROKES.put("pmd-cpd", new BasicStroke(2.0f, 1, 2));
        STROKES.put("pmd", new BasicStroke(2.0f, 1, 2));
    }
}

