/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.renderer.xy.VectorRenderer;
import org.jfree.experimental.data.xy.VectorSeries;
import org.jfree.experimental.data.xy.VectorSeriesCollection;
import org.jfree.experimental.data.xy.VectorXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class VectorPlotDemo1
extends ApplicationFrame {
    public VectorPlotDemo1(String title) {
        super(title);
        JPanel chartPanel = VectorPlotDemo1.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static JFreeChart createChart(VectorXYDataset dataset) {
        NumberAxis xAxis = new NumberAxis("X");
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis("Y");
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        yAxis.setLowerMargin(0.01);
        yAxis.setUpperMargin(0.01);
        yAxis.setAutoRangeIncludesZero(false);
        VectorRenderer renderer = new VectorRenderer();
        renderer.setSeriesPaint(0, Color.blue);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setOutlinePaint((Paint)Color.black);
        JFreeChart chart = new JFreeChart("Vector Plot Demo 1", (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    private static VectorXYDataset createDataset() {
        VectorSeries s1 = new VectorSeries((Comparable)((Object)"Series 1"));
        for (double r = 0.0; r < 20.0; r += 1.0) {
            for (double c = 0.0; c < 20.0; c += 1.0) {
                s1.add(r + 10.0, c + 10.0, Math.sin(r / 5.0) / 2.0, Math.cos(c / 5.0) / 2.0);
            }
        }
        VectorSeriesCollection dataset = new VectorSeriesCollection();
        dataset.addSeries(s1);
        return dataset;
    }

    public static JPanel createDemoPanel() {
        return new ChartPanel(VectorPlotDemo1.createChart(VectorPlotDemo1.createDataset()));
    }

    public static void main(String[] args) {
        VectorPlotDemo1 demo = new VectorPlotDemo1("JFreeChart : Vector Plot Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

