/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import net.objectlab.qalab.m2.BuildStatChartMojo;
import net.objectlab.qalab.m2.QALabStatAllMergeMojo;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.m2.util.XmlTransformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class MergeAndChartReport
extends AbstractMavenReport {
    private File checkstyleInputFile = null;
    private String checkstyleHandler;
    private File pmdInputFile = null;
    private String pmdHandler;
    private File pmdCpdInputFile = null;
    private String pmdCpdHandler;
    private File findbugsInputFile = null;
    private String findbugsHandler;
    private File simianInputFile = null;
    private String simianHandler;
    private File coberturaInputFile = null;
    private String coberturaLineHandler;
    private String coberturaBranchHandler;
    private boolean quiet = false;
    private boolean dateOnly = true;
    private String srcDir;
    private String mergerTimeStamp;
    private String exporterClassName = "net.objectlab.qalab.exporter.QALabXMLExporter";
    private File propertiesFile;
    private Properties theProperties = null;
    private File chartOutputDirectory;
    private int chartWidth;
    private int chartHeight;
    private int movingAverage = 0;
    private boolean chartSummaryOnly = false;
    private String summaryTypes = "checkstyle,pmd,findbugs,simian,pmd-cpd";
    private String chartFilePrefix = "";
    private String xAxisTitle = "Date";
    private String yAxisTitle = "Violation Count / Coverage Percent";
    private String xAxisSummaryTitle = "Date";
    private String yAxisSummaryTitle = "Violation Count";
    private File qalabFile = null;
    private String chartBundledXsl = null;
    private String outputDirectory;
    private String types = "checkstyle,pmd,pmd-cpd,findbugs,simian,cobertura-line,cobertura-branch";
    private InputStream theXmlStream = null;
    private File styleSheet = null;
    private InputStream theStyleSheetStream = null;
    private String startTimeHoursOffset = "48";
    private String theOffset;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void executeReport(Locale aLocale) throws MavenReportException {
        File output;
        this.getLog().info((CharSequence)"QALab: Merge and Chart Report");
        try {
            this.doMerge();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Issue during Merge", (Exception)((Object)e));
        }
        try {
            this.doChart();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Issue during Chart", (Exception)((Object)e));
        }
        this.validate();
        this.getLog().info((CharSequence)("Output Directory: " + this.getOutputDirectory()));
        File outdir = new File(this.getOutputDirectory());
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        if (!$assertionsDisabled && !outdir.isDirectory()) {
            throw new AssertionError((Object)"the output directory was not a directory");
        }
        try {
            output = File.createTempFile("qalab", null, outdir);
            if (!$assertionsDisabled && output == null) {
                throw new AssertionError((Object)"the temp file is null.");
            }
        }
        catch (IOException ioex) {
            throw new MavenReportException("could not create temp file.", (Exception)ioex);
        }
        XmlTransformer t = new XmlTransformer(this.theXmlStream, this.theStyleSheetStream, output);
        t.addParameter("targetdir", this.getOutputDirectory());
        t.addParameter("type", this.types);
        t.addParameter("offset", this.theOffset);
        try {
            t.transform();
        }
        catch (TransformerException tex) {
            throw new MavenReportException("transformation failed.", (Exception)tex);
        }
        output.deleteOnExit();
    }

    private void doMerge() throws MojoExecutionException {
        QALabStatAllMergeMojo mojo = new QALabStatAllMergeMojo();
        mojo.setCheckstyleHandler(this.checkstyleHandler);
        mojo.setCheckstyleInputFile(this.checkstyleInputFile);
        mojo.setPmdCpdHandler(this.pmdCpdHandler);
        mojo.setPmdCpdInputFile(this.pmdCpdInputFile);
        mojo.setPmdHandler(this.pmdHandler);
        mojo.setPmdInputFile(this.pmdInputFile);
        mojo.setSimianHandler(this.simianHandler);
        mojo.setSimianInputFile(this.simianInputFile);
        mojo.setCoberturaBranchHandler(this.coberturaBranchHandler);
        mojo.setCoberturaInputFile(this.coberturaInputFile);
        mojo.setCoberturaLineHandler(this.coberturaLineHandler);
        mojo.setDateOnly(this.dateOnly);
        mojo.setExporterClassName(this.exporterClassName);
        mojo.setFindbugsHandler(this.findbugsHandler);
        mojo.setFindbugsInputFile(this.findbugsInputFile);
        mojo.setMergerTimeStamp(this.mergerTimeStamp);
        mojo.setOutputFile(this.qalabFile);
        mojo.setPropertiesFile(this.propertiesFile);
        mojo.setQuiet(this.quiet);
        mojo.setSrcDir(this.srcDir);
        mojo.setTheProperties(this.theProperties);
        mojo.setPluginContext(this.getPluginContext());
        mojo.execute();
    }

    private void doChart() throws MojoExecutionException {
        BuildStatChartMojo mojo = new BuildStatChartMojo();
        mojo.setFilePrefix(this.chartFilePrefix);
        mojo.setSummaryOnly(this.chartSummaryOnly);
        mojo.setSummaryTypes(this.summaryTypes);
        mojo.setHeight(this.chartHeight);
        mojo.setWidth(this.chartWidth);
        mojo.setMovingAverage(this.movingAverage);
        mojo.setQalabFile(this.qalabFile);
        mojo.setQuiet(this.quiet);
        mojo.setToDir(this.chartOutputDirectory);
        mojo.setTypes(this.types);
        mojo.setPluginContext(this.getPluginContext());
        mojo.setXAxisSummaryTitle(this.xAxisSummaryTitle);
        mojo.setXAxisTitle(this.xAxisTitle);
        mojo.setYAxisSummaryTitle(this.yAxisSummaryTitle);
        mojo.setYAxisTitle(this.yAxisTitle);
        mojo.execute();
        mojo.setFilePrefix("cobertura-" + this.chartFilePrefix);
        mojo.setSummaryOnly(true);
        mojo.setSummaryTypes("cobertura-line,cobertura-branch");
        mojo.setYAxisSummaryTitle("Coverage Percent");
        mojo.execute();
    }

    public final String getOutputName() {
        return "qalab/index";
    }

    protected final String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public final String getName(Locale aLocale) {
        return MergeAndChartReport.getBundle(aLocale).getString("report.qalab.name");
    }

    public final String getDescription(Locale aLocale) {
        return MergeAndChartReport.getBundle(aLocale).getString("report.qalab.description");
    }

    public final boolean isExternalReport() {
        return true;
    }

    private static ResourceBundle getBundle(Locale aLocale) {
        return ResourceBundle.getBundle("qalab-report", aLocale, MergeAndChartReport.class.getClassLoader());
    }

    public void setXAxisSummaryTitle(String xAxisSummaryTitle) {
        this.xAxisSummaryTitle = xAxisSummaryTitle;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public void setYAxisSummaryTitle(String yAxisSummaryTitle) {
        this.yAxisSummaryTitle = yAxisSummaryTitle;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    private void validate() throws MavenReportException {
        try {
            Utils.checkFile(this.qalabFile, "qalabFile");
            this.theXmlStream = new FileInputStream(this.qalabFile);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.styleSheet == null) {
            try {
                this.theStyleSheetStream = Utils.extractAsInputStream(this.chartBundledXsl);
            }
            catch (IOException ioex) {
                throw new MavenReportException("Could not find the default stylesheet. " + ioex.getMessage(), (Exception)ioex);
            }
        }
        try {
            Utils.checkFile(this.styleSheet, "styleSheet");
            this.theStyleSheetStream = new FileInputStream(this.styleSheet);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
        this.theOffset = Utils.formatDateBasedOnOffset(this.startTimeHoursOffset);
    }

    static {
        $assertionsDisabled = !MergeAndChartReport.class.desiredAssertionStatus();
    }
}

