/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private SourceLocator locator = null;
    private Throwable containedException = null;
    private boolean causeKnown;

    public TransformerException(String string) {
        super(string);
    }

    public TransformerException(Throwable throwable) {
        this.initCause(throwable);
    }

    public TransformerException(String string, Throwable throwable) {
        super(string);
        this.initCause(throwable);
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        super(string);
        this.setLocator(sourceLocator);
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.setLocator(sourceLocator);
        this.initCause(throwable);
    }

    public Throwable getCause() {
        return this.containedException;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.locator.getPublicId() != null) {
            stringBuffer.append("public='");
            stringBuffer.append(this.locator.getPublicId());
            stringBuffer.append("' ");
        }
        if (this.locator.getSystemId() != null) {
            stringBuffer.append("uri='");
            stringBuffer.append(this.locator.getSystemId());
            stringBuffer.append("' ");
        }
        if (this.locator.getLineNumber() != -1) {
            stringBuffer.append("line=");
            stringBuffer.append(this.locator.getLineNumber());
            stringBuffer.append(" ");
        }
        if (this.locator.getColumnNumber() != -1) {
            stringBuffer.append("column=");
            stringBuffer.append(this.locator.getColumnNumber());
        }
        return stringBuffer.toString();
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public String getMessageAndLocation() {
        if (this.locator == null) {
            return this.getMessage();
        }
        return this.getMessage() + ": " + this.getLocationAsString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        if (this.containedException != null) {
            throw new IllegalStateException();
        }
        this.containedException = throwable;
        this.causeKnown = true;
        return throwable;
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(printStream));
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.containedException != null) {
            this.containedException.printStackTrace(printWriter);
        }
        super.printStackTrace(printWriter);
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }
}

