/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo5
extends ApplicationFrame {
    public TimeSeriesDemo5(String string) {
        super(string);
        XYDataset xYDataset = TimeSeriesDemo5.createDataset();
        JFreeChart jFreeChart = TimeSeriesDemo5.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart, false);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries("Random Data");
        Day day = new Day(1, 1, 1990);
        double d = 100.0;
        for (int i = 0; i < 4000; ++i) {
            try {
                d = d + Math.random() - 0.5;
                timeSeries.add((RegularTimePeriod)day, new Double(d));
                day = (Day)day.next();
                continue;
            }
            catch (SeriesException seriesException) {
                System.err.println("Error adding to series");
            }
        }
        return new TimeSeriesCollection(timeSeries);
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Test", "Day", "Value", xYDataset, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setBaseShapesVisible(false);
        xYLineAndShapeRenderer.setSeriesStroke(0, new BasicStroke(0.5f, 1, 1, 5.0f, new float[]{5.0f, 10.0f}, 0.0f));
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = TimeSeriesDemo5.createChart(TimeSeriesDemo5.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        String string = "\u20a2\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa";
        TimeSeriesDemo5 timeSeriesDemo5 = new TimeSeriesDemo5(string);
        timeSeriesDemo5.pack();
        RefineryUtilities.positionFrameRandomly((Window)((Object)timeSeriesDemo5));
        timeSeriesDemo5.setVisible(true);
    }
}

