/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo6
extends ApplicationFrame {
    public BarChartDemo6(String string) {
        super(string);
        CategoryDataset categoryDataset = BarChartDemo6.createDataset();
        JFreeChart jFreeChart = BarChartDemo6.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(83.0, (Comparable)((Object)"First"), (Comparable)((Object)"Factor 1"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart(null, "Category", "Score (%)", categoryDataset, PlotOrientation.HORIZONTAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.yellow);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setRangeGridlinesVisible(false);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLowerMargin(0.2);
        categoryAxis.setUpperMargin(0.2);
        categoryAxis.setVisible(false);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setRange(0.0, 100.0);
        numberAxis.setVisible(false);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BarChartDemo6.createChart(BarChartDemo6.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        BarChartDemo6 barChartDemo6 = new BarChartDemo6("Minimal Chart Demo");
        barChartDemo6.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo6));
        barChartDemo6.setVisible(true);
    }
}

