/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.objectlab.qalab.interfaces.QALabExporter;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.StatMerger;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;

public class QALabStatAllMergeMojo
extends AbstractMojo {
    private File checkstyleInputFile = null;
    private String checkstyleHandler;
    private File pmdInputFile = null;
    private String pmdHandler;
    private File pmdCpdInputFile = null;
    private String pmdCpdHandler;
    private File findbugsInputFile = null;
    private String findbugsHandler;
    private File simianInputFile = null;
    private String simianHandler;
    private File coberturaInputFile = null;
    private String coberturaLineHandler;
    private String coberturaBranchHandler;
    private File outputFile = null;
    private boolean quiet = false;
    private boolean dateOnly = true;
    private String srcDir;
    private String mergerTimeStamp;
    private String exporterClassName = "net.objectlab.qalab.exporter.QALabXMLExporter";
    private File propertiesFile;
    private Properties theProperties = null;

    public final void execute() throws MojoExecutionException {
        this.theProperties = this.createOverridingProperties();
        this.getLog().info((CharSequence)"Starting QALab ALL Merge");
        this.doMerge(this.checkstyleInputFile, this.checkstyleHandler);
        this.doMerge(this.pmdInputFile, this.pmdHandler);
        this.doMerge(this.pmdCpdInputFile, this.pmdCpdHandler);
        this.doMerge(this.findbugsInputFile, this.findbugsHandler);
        this.doMerge(this.simianInputFile, this.simianHandler);
        this.doMerge(this.coberturaInputFile, this.coberturaLineHandler);
        this.doMerge(this.coberturaInputFile, this.coberturaBranchHandler);
        if (!this.getOutputFile().exists()) {
            try {
                QALabExporter exporter = (QALabExporter)Class.forName(this.getExporterClassName()).newInstance();
                this.getTheProperties().setProperty("qalab.merge.output.file", this.getOutputFile().getAbsolutePath());
                exporter.setQuiet(this.isQuiet());
                exporter.setTaskLogger((TaskLogger)new Maven2TaskLogger((Mojo)this));
                exporter.configure(this.getTheProperties());
                exporter.save();
            }
            catch (Exception excn) {
                excn.printStackTrace();
            }
        }
    }

    private void doMerge(File inputFile, String handler) throws MojoExecutionException {
        if (!this.validate(inputFile)) {
            return;
        }
        if (!this.quiet) {
            this.getLog().info((CharSequence)"----------------------------------------------");
            this.getLog().info((CharSequence)"QALab Merge:");
            this.getLog().info((CharSequence)("checkstyleInputFile='" + inputFile.getPath()));
            this.getLog().info((CharSequence)("outputFile='" + this.outputFile.getPath()));
            this.getLog().info((CharSequence)("srcDir='" + this.srcDir + "', mergerTimeStamp=" + this.mergerTimeStamp));
            String proppath = null;
            if (this.propertiesFile != null) {
                proppath = this.propertiesFile.getPath();
            }
            this.getLog().info((CharSequence)("quiet='" + this.quiet + "', propertiesFile='" + proppath + "'."));
            Iterator<Map.Entry<Object, Object>> it = this.theProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = entry.getKey().toString();
                if (key.indexOf("qalab") < 0) continue;
                this.getLog().info((CharSequence)(key + " = '" + entry.getValue() + "'"));
            }
        }
        this.mergeFiles(inputFile, handler);
    }

    private void mergeFiles(File inputFile, String handler) throws MojoExecutionException {
        try {
            Maven2TaskLogger logger = new Maven2TaskLogger((Mojo)this);
            QALabExporter exporter = (QALabExporter)Class.forName(this.getExporterClassName()).newInstance();
            this.getTheProperties().setProperty("qalab.merge.output.file", this.getOutputFile().getAbsolutePath());
            exporter.setQuiet(this.isQuiet());
            exporter.setTaskLogger((TaskLogger)logger);
            StatMerger merger = (StatMerger)Class.forName(handler).newInstance();
            merger.setQuiet(this.isQuiet());
            merger.setSrcDir(this.getSrcDir());
            merger.setTaskLogger((TaskLogger)logger);
            merger.setMergerTimeStamp(this.getMergerTimeStamp(), this.dateOnly);
            this.getTheProperties().setProperty("qalab.merge.output.timestamp", merger.getMergerTimeStamp());
            this.getTheProperties().setProperty("qalab.merge.type", merger.getType());
            exporter.configure(this.getTheProperties());
            merger.mergeStats(new InputSource(new FileInputStream(inputFile)), exporter);
            this.getLog().info((CharSequence)("Files: " + merger.getFileCount() + " Violations:" + merger.getTotalStatistics()));
            exporter.save();
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(e.toString());
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    private boolean validate(File file) {
        try {
            Utils.checkFile(file, "inputFile");
            return true;
        }
        catch (IOException ioex) {
            this.getLog().warn((CharSequence)("\n\nQALab ==> The file " + file.getPath() + " cannot be accessed. SKIPPING....\n\n"));
            return false;
        }
    }

    private Properties createOverridingProperties() throws MojoExecutionException {
        Map projectContext;
        Properties result = new Properties();
        if (this.propertiesFile != null && this.propertiesFile.canRead() && this.propertiesFile.isFile()) {
            FileInputStream inStream = null;
            if (!this.quiet) {
                this.getLog().debug((CharSequence)("loading " + this.propertiesFile));
            }
            try {
                inStream = new FileInputStream(this.propertiesFile);
                result.load(inStream);
            }
            catch (FileNotFoundException fnfex) {
                throw new MojoExecutionException("Could not find Properties file '" + this.propertiesFile + "'", (Exception)fnfex);
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Error loading Properties file '" + this.propertiesFile + "'", (Exception)ioex);
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException ioex) {
                    throw new MojoExecutionException("Error closing Properties file '" + this.propertiesFile + "'", (Exception)ioex);
                }
            }
        }
        if ((projectContext = this.getPluginContext()) != null) {
            Iterator it = projectContext.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String value = String.valueOf(entry.getValue());
                if (entry.getKey().toString().indexOf("qalab") >= 0) {
                    this.getLog().info((CharSequence)("Adding " + entry.getKey() + " / " + value));
                }
                result.put(entry.getKey(), value);
            }
        }
        return result;
    }

    public String getExporterClassName() {
        return this.exporterClassName;
    }

    public void setExporterClassName(String exporterClassName) {
        this.exporterClassName = exporterClassName;
    }

    public File getInputFile() {
        return this.checkstyleInputFile;
    }

    public void setInputFile(File inputFile) {
        this.checkstyleInputFile = inputFile;
    }

    public String getMergerTimeStamp() {
        return this.mergerTimeStamp;
    }

    public void setMergerTimeStamp(String mergerTimeStamp) {
        this.mergerTimeStamp = mergerTimeStamp;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public Properties getTheProperties() {
        return this.theProperties;
    }

    public void setTheProperties(Properties theProperties) {
        this.theProperties = theProperties;
    }

    public String getCheckstyleHandler() {
        return this.checkstyleHandler;
    }

    public void setCheckstyleHandler(String checkstyleHandler) {
        this.checkstyleHandler = checkstyleHandler;
    }

    public File getCheckstyleInputFile() {
        return this.checkstyleInputFile;
    }

    public void setCheckstyleInputFile(File checkstyleInputFile) {
        this.checkstyleInputFile = checkstyleInputFile;
    }

    public String getCoberturaBranchHandler() {
        return this.coberturaBranchHandler;
    }

    public void setCoberturaBranchHandler(String coberturaBranchHandler) {
        this.coberturaBranchHandler = coberturaBranchHandler;
    }

    public File getCoberturaInputFile() {
        return this.coberturaInputFile;
    }

    public void setCoberturaInputFile(File coberturaInputFile) {
        this.coberturaInputFile = coberturaInputFile;
    }

    public String getCoberturaLineHandler() {
        return this.coberturaLineHandler;
    }

    public void setCoberturaLineHandler(String coberturaLineHandler) {
        this.coberturaLineHandler = coberturaLineHandler;
    }

    public boolean isDateOnly() {
        return this.dateOnly;
    }

    public void setDateOnly(boolean dateOnly) {
        this.dateOnly = dateOnly;
    }

    public String getFindbugsHandler() {
        return this.findbugsHandler;
    }

    public void setFindbugsHandler(String findbugsHandler) {
        this.findbugsHandler = findbugsHandler;
    }

    public File getFindbugsInputFile() {
        return this.findbugsInputFile;
    }

    public void setFindbugsInputFile(File findbugsInputFile) {
        this.findbugsInputFile = findbugsInputFile;
    }

    public String getPmdCpdHandler() {
        return this.pmdCpdHandler;
    }

    public void setPmdCpdHandler(String pmdCpdHandler) {
        this.pmdCpdHandler = pmdCpdHandler;
    }

    public File getPmdCpdInputFile() {
        return this.pmdCpdInputFile;
    }

    public void setPmdCpdInputFile(File pmdCpdInputFile) {
        this.pmdCpdInputFile = pmdCpdInputFile;
    }

    public String getPmdHandler() {
        return this.pmdHandler;
    }

    public void setPmdHandler(String pmdHandler) {
        this.pmdHandler = pmdHandler;
    }

    public File getPmdInputFile() {
        return this.pmdInputFile;
    }

    public void setPmdInputFile(File pmdInputFile) {
        this.pmdInputFile = pmdInputFile;
    }

    public String getSimianHandler() {
        return this.simianHandler;
    }

    public void setSimianHandler(String simianHandler) {
        this.simianHandler = simianHandler;
    }

    public File getSimianInputFile() {
        return this.simianInputFile;
    }

    public void setSimianInputFile(File simianInputFile) {
        this.simianInputFile = simianInputFile;
    }
}

