/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.objectlab.qalab.interfaces.QALabExporter;
import net.objectlab.qalab.parser.StatMerger;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseStatMerge
extends DefaultHandler
implements StatMerger {
    private int totalStatistics = 0;
    private int fileCount = 0;
    private int fileStatistics = 0;
    private String currentFile = null;
    private boolean quiet = true;
    private TaskLogger taskLogger = null;
    private String srcDir;
    private QALabExporter exporter = null;
    private Date mergerTimeStamp;
    private boolean timeStampAsDateOnly = true;

    public final void setCurrentFile(String theFile) {
        this.currentFile = theFile;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean noLog) {
        this.quiet = noLog;
    }

    public final void setTaskLogger(TaskLogger task) {
        this.taskLogger = task;
    }

    protected final TaskLogger getTaskLogger() {
        return this.taskLogger;
    }

    public final void setSrcDir(String directory) {
        this.srcDir = directory.replace('\\', '/');
    }

    public final String getSrcDir() {
        return this.srcDir;
    }

    protected final void addNewResults() {
        if (this.getFileStatistics() != 0) {
            this.exporter.addFileResult(this.getFileStatistics(), this.currentFile);
        } else if (!this.isQuiet()) {
            this.taskLogger.log("No violation for " + this.currentFile);
        }
    }

    public int getTotalStatistics() {
        return this.totalStatistics;
    }

    protected final void addTotalStatistics(int increment) {
        this.totalStatistics += increment;
    }

    protected final void setTotalStatistics(int value) {
        this.totalStatistics = value;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    protected final void incrementFileCount(int increment) {
        this.fileCount += increment;
    }

    protected final int getFileStatistics() {
        return this.fileStatistics;
    }

    protected final void addFileStatistics(int increment) {
        this.fileStatistics += increment;
        this.addTotalStatistics(increment);
    }

    protected final void resetFileStatistics() {
        this.fileStatistics = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeStats(InputSource source, QALabExporter qalabExporter) {
        this.exporter = qalabExporter;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
            saxParser.getXMLReader().setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParser.getXMLReader().setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            InputSource src = this.preProcessSource(source);
            saxParser.parse(src, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            this.getTaskLogger().log(e.toString());
        }
        catch (SAXException e) {
            this.getTaskLogger().log(e.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getTaskLogger().log(e.toString());
        }
        finally {
            if (!this.isQuiet()) {
                this.getTaskLogger().log("Finished Parsing Source XML.");
            }
        }
        if (this.getTotalStatistics() != 0) {
            this.exporter.addSummary(this.getTotalStatistics(), this.getFileCount());
        }
    }

    protected InputSource preProcessSource(InputSource source) {
        return source;
    }

    public final void setMergerTimeStamp(String timestamp, boolean timeStampAsDate) {
        this.timeStampAsDateOnly = timeStampAsDate;
        if (timestamp != null) {
            try {
                this.mergerTimeStamp = QALabTags.DEFAULT_DATETIME_FORMAT.parse(timestamp);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Wrong format for mergerTimeStamp. " + e.getMessage());
            }
        } else {
            this.mergerTimeStamp = new Date();
        }
        if (timeStampAsDate) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.mergerTimeStamp);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.mergerTimeStamp = cal.getTime();
        }
    }

    public final String getMergerTimeStamp() {
        if (this.mergerTimeStamp == null) {
            this.setMergerTimeStamp(null, this.timeStampAsDateOnly);
        }
        if (this.timeStampAsDateOnly) {
            return QALabTags.DEFAULT_DATE_FORMAT.format(this.mergerTimeStamp);
        }
        return QALabTags.DEFAULT_DATETIME_FORMAT.format(this.mergerTimeStamp);
    }
}

