/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.experimental.chart.plot.dial.AbstractDialLayer;
import org.jfree.experimental.chart.plot.dial.DialFrame;
import org.jfree.experimental.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.experimental.chart.plot.dial.DialPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class SimpleDialFrame
extends AbstractDialLayer
implements DialFrame,
Cloneable,
PublicCloneable,
Serializable {
    private double radius = 0.95;
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = Color.black;
    private transient Stroke stroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Shape getWindow(Rectangle2D frame) {
        Rectangle2D f = DialPlot.rectangleByRadius(frame, this.radius, this.radius);
        return new Ellipse2D.Double(f.getX(), f.getY(), f.getWidth(), f.getHeight());
    }

    public boolean isClippedToWindow() {
        return false;
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Shape window = this.getWindow(frame);
        Rectangle2D f = DialPlot.rectangleByRadius(frame, this.radius + 0.02, this.radius + 0.02);
        Ellipse2D.Double e = new Ellipse2D.Double(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        Area area = new Area(e);
        Area area2 = new Area(window);
        area.subtract(area2);
        g2.setPaint(this.backgroundPaint);
        g2.fill(area);
        g2.setStroke(this.stroke);
        g2.setPaint(this.foregroundPaint);
        g2.draw(window);
        g2.draw(e);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleDialFrame)) {
            return false;
        }
        SimpleDialFrame that = (SimpleDialFrame)obj;
        if (!PaintUtilities.equal((Paint)this.backgroundPaint, (Paint)that.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.foregroundPaint, (Paint)that.foregroundPaint)) {
            return false;
        }
        if (this.radius != that.radius) {
            return false;
        }
        return this.stroke.equals(that.stroke);
    }

    public int hashCode() {
        int result = 193;
        long temp = Double.doubleToLongBits(this.radius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        result = 37 * result + HashUtilities.hashCodeForPaint((Paint)this.backgroundPaint);
        result = 37 * result + HashUtilities.hashCodeForPaint((Paint)this.foregroundPaint);
        result = 37 * result + this.stroke.hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.foregroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.foregroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)stream);
    }
}

