/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import hidden.org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.io.xpp3.ProfilesXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProfilesBuilder
extends AbstractLogEnabled
implements MavenProfilesBuilder {
    private static final String PROFILES_XML_FILE = "profiles.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilesRoot buildProfiles(File basedir) throws IOException, XmlPullParserException {
        File profilesXml = new File(basedir, PROFILES_XML_FILE);
        ProfilesRoot profilesRoot = null;
        if (profilesXml.exists()) {
            ProfilesXpp3Reader reader = new ProfilesXpp3Reader();
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(profilesXml);
                StringWriter sWriter = new StringWriter();
                IOUtil.copy((Reader)fileReader, (Writer)sWriter);
                String rawInput = sWriter.toString();
                try {
                    RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
                    interpolator.addValueSource(new EnvarBasedValueSource());
                    rawInput = interpolator.interpolate(rawInput, "settings");
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to initialize environment variable resolver. Skipping environment substitution in profiles.xml.");
                    this.getLogger().debug("Failed to initialize envar resolver. Skipping resolution.", e);
                }
                StringReader sReader = new StringReader(rawInput);
                profilesRoot = reader.read(sReader);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
            IOUtil.close(fileReader);
        }
        return profilesRoot;
    }
}

