/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends InstallDeployTaskSupport {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;

    protected void doExecute() {
        ArtifactRepository deploymentRepository;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to deploy to the repository");
        }
        Artifact artifact = this.createArtifact(pom);
        DistributionManagement distributionManagement = pom.getDistributionManagement();
        if (this.remoteSnapshotRepository == null && this.remoteRepository == null && distributionManagement != null) {
            if (distributionManagement.getSnapshotRepository() != null) {
                this.remoteSnapshotRepository = this.createAntRemoteRepositoryBase(distributionManagement.getSnapshotRepository());
            }
            if (distributionManagement.getRepository() != null) {
                this.remoteRepository = this.createAntRemoteRepositoryBase(distributionManagement.getRepository());
            }
        }
        if (this.remoteSnapshotRepository == null) {
            this.remoteSnapshotRepository = this.remoteRepository;
        }
        if (artifact.isSnapshot() && this.remoteSnapshotRepository != null) {
            deploymentRepository = this.createRemoteArtifactRepository(this.remoteSnapshotRepository);
        } else if (this.remoteRepository != null) {
            deploymentRepository = this.createRemoteArtifactRepository(this.remoteRepository);
        } else {
            throw new BuildException("A distributionManagement element or remoteRepository element is required to deploy");
        }
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata(metadata);
        }
        this.log("Deploying to " + deploymentRepository.getUrl());
        ArtifactDeployer deployer = (ArtifactDeployer)this.lookup(ArtifactDeployer.ROLE);
        try {
            if (!isPomArtifact) {
                deployer.deploy(this.file, artifact, deploymentRepository, localRepo);
            } else {
                deployer.deploy(pom.getFile(), artifact, deploymentRepository, localRepo);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new BuildException("Error deploying artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
        if (this.attachedArtifacts != null) {
            Iterator iter = this.attachedArtifacts.iterator();
            while (iter.hasNext()) {
                AttachedArtifact attached = (AttachedArtifact)iter.next();
                Artifact attachedArtifact = this.createArtifactFromAttached(attached, artifact);
                try {
                    deployer.deploy(attachedArtifact.getFile(), attachedArtifact, deploymentRepository, localRepo);
                }
                catch (ArtifactDeploymentException e) {
                    throw new BuildException("Error deploying attached artifact '" + attachedArtifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public void addRemoteSnapshotRepository(RemoteRepository remoteSnapshotRepository) {
        this.remoteSnapshotRepository = remoteSnapshotRepository;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }
}

