/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.DateCellRenderer;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class CrosshairDemo1
extends ApplicationFrame {
    public CrosshairDemo1(String string) {
        super(string);
        this.setContentPane(new DemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        CrosshairDemo1 crosshairDemo1 = new CrosshairDemo1("Crosshair Demo 1");
        crosshairDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)crosshairDemo1));
        crosshairDemo1.setVisible(true);
    }

    static class DemoTableModel
    extends AbstractTableModel
    implements TableModel {
        private Object[][] data;

        public DemoTableModel(int n) {
            this.data = new Object[n][7];
        }

        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            return 1;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Series Name:";
                }
                case 1: {
                    return "X:";
                }
                case 2: {
                    return "Y:";
                }
                case 3: {
                    return "X (prev)";
                }
                case 4: {
                    return "Y (prev):";
                }
                case 5: {
                    return "X (next):";
                }
                case 6: {
                    return "Y (next):";
                }
            }
            return null;
        }
    }

    private static class DemoPanel
    extends JPanel
    implements ChangeListener,
    ChartProgressListener {
        private TimeSeries series;
        private ChartPanel chartPanel;
        private DemoTableModel model;
        private JFreeChart chart = this.createChart();
        private JSlider slider;

        public DemoPanel() {
            super(new BorderLayout());
            this.chart.addProgressListener(this);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(600, 270));
            this.chartPanel.setDomainZoomable(true);
            this.chartPanel.setRangeZoomable(true);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
            this.chartPanel.setBorder(compoundBorder);
            this.add(this.chartPanel);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setPreferredSize(new Dimension(400, 60));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.model = new DemoTableModel(3);
            XYPlot xYPlot = (XYPlot)this.chart.getPlot();
            this.model.setValueAt(xYPlot.getDataset().getSeriesKey(0), 0, 0);
            this.model.setValueAt(new Double("0.00"), 0, 1);
            this.model.setValueAt(new Double("0.00"), 0, 2);
            this.model.setValueAt(new Double("0.00"), 0, 3);
            this.model.setValueAt(new Double("0.00"), 0, 4);
            this.model.setValueAt(new Double("0.00"), 0, 5);
            this.model.setValueAt(new Double("0.00"), 0, 6);
            JTable jTable = new JTable(this.model);
            DateCellRenderer dateCellRenderer = new DateCellRenderer((DateFormat)new SimpleDateFormat("HH:mm"));
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            jTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)dateCellRenderer);
            jTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)numberCellRenderer);
            jTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)dateCellRenderer);
            jTable.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)numberCellRenderer);
            jTable.getColumnModel().getColumn(5).setCellRenderer((TableCellRenderer)dateCellRenderer);
            jTable.getColumnModel().getColumn(6).setCellRenderer((TableCellRenderer)numberCellRenderer);
            jPanel.add(new JScrollPane(jTable));
            this.slider = new JSlider(0, 100, 50);
            this.slider.addChangeListener(this);
            jPanel.add((Component)this.slider, "South");
            this.add((Component)jPanel, "South");
        }

        private JFreeChart createChart() {
            XYDataset xYDataset = this.createDataset("Random 1", 100.0, new Minute(), 200);
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Crosshair Demo 1", "Time of Day", "Value", xYDataset, true, true, false);
            jFreeChart.setBackgroundPaint(Color.white);
            XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
            xYPlot.setOrientation(PlotOrientation.VERTICAL);
            xYPlot.setBackgroundPaint(Color.lightGray);
            xYPlot.setDomainGridlinePaint(Color.white);
            xYPlot.setRangeGridlinePaint(Color.white);
            xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            xYPlot.setDomainCrosshairVisible(true);
            xYPlot.setDomainCrosshairLockedOnData(false);
            xYPlot.setRangeCrosshairVisible(false);
            XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
            xYItemRenderer.setPaint(Color.black);
            return jFreeChart;
        }

        private XYDataset createDataset(String string, double d, RegularTimePeriod regularTimePeriod, int n) {
            this.series = new TimeSeries(string, regularTimePeriod.getClass());
            RegularTimePeriod regularTimePeriod2 = regularTimePeriod;
            double d2 = d;
            for (int i = 0; i < n; ++i) {
                this.series.add(regularTimePeriod2, d2);
                regularTimePeriod2 = regularTimePeriod2.next();
                d2 *= 1.0 + (Math.random() - 0.495) / 10.0;
            }
            TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
            timeSeriesCollection.addSeries(this.series);
            return timeSeriesCollection;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = this.slider.getValue();
            XYPlot xYPlot = (XYPlot)this.chart.getPlot();
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            Range range = valueAxis.getRange();
            double d = valueAxis.getLowerBound() + (double)n / 100.0 * range.getLength();
            xYPlot.setDomainCrosshairValue(d);
        }

        public void chartProgress(ChartProgressEvent chartProgressEvent) {
            JFreeChart jFreeChart;
            if (chartProgressEvent.getType() != 2) {
                return;
            }
            if (this.chartPanel != null && (jFreeChart = this.chartPanel.getChart()) != null) {
                XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
                XYDataset xYDataset = xYPlot.getDataset();
                Comparable comparable = xYDataset.getSeriesKey(0);
                double d = xYPlot.getDomainCrosshairValue();
                this.model.setValueAt(comparable, 0, 0);
                long l = (long)d;
                this.model.setValueAt(new Long(l), 0, 1);
                int n = this.series.getIndex(new Minute(new Date(l)));
                if (n >= 0) {
                    TimeSeriesDataItem timeSeriesDataItem = this.series.getDataItem(Math.min(199, Math.max(0, n)));
                    TimeSeriesDataItem timeSeriesDataItem2 = this.series.getDataItem(Math.max(0, n - 1));
                    TimeSeriesDataItem timeSeriesDataItem3 = this.series.getDataItem(Math.min(199, n + 1));
                    long l2 = timeSeriesDataItem.getPeriod().getMiddleMillisecond();
                    double d2 = timeSeriesDataItem.getValue().doubleValue();
                    long l3 = timeSeriesDataItem2.getPeriod().getMiddleMillisecond();
                    double d3 = timeSeriesDataItem2.getValue().doubleValue();
                    long l4 = timeSeriesDataItem3.getPeriod().getMiddleMillisecond();
                    double d4 = timeSeriesDataItem3.getValue().doubleValue();
                    this.model.setValueAt(new Long(l2), 0, 1);
                    this.model.setValueAt(new Double(d2), 0, 2);
                    this.model.setValueAt(new Long(l3), 0, 3);
                    this.model.setValueAt(new Double(d3), 0, 4);
                    this.model.setValueAt(new Long(l4), 0, 5);
                    this.model.setValueAt(new Double(d4), 0, 6);
                }
            }
        }
    }
}

