/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.plot.dial;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.experimental.chart.plot.dial.AbstractDialLayer;
import org.jfree.experimental.chart.plot.dial.DialFrame;
import org.jfree.experimental.chart.plot.dial.DialLayerChangeEvent;
import org.jfree.experimental.chart.plot.dial.DialPlot;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class StandardDialFrame
extends AbstractDialLayer
implements DialFrame,
Cloneable,
PublicCloneable,
Serializable {
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = new Color(100, 100, 150);
    private transient Stroke stroke = new BasicStroke(2.0f);
    private double startAngle;
    private double extent;
    private double innerRadius = 0.25;
    private double outerRadius = 0.75;

    public StandardDialFrame() {
        this(0.0, 180.0);
    }

    public StandardDialFrame(double startAngle, double extent) {
        this.startAngle = startAngle;
        this.extent = extent;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double radius) {
        this.innerRadius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double radius) {
        this.outerRadius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double extent) {
        this.extent = extent;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Shape getWindow(Rectangle2D frame) {
        Rectangle2D innerFrame = DialPlot.rectangleByRadius(frame, this.innerRadius, this.innerRadius);
        Rectangle2D outerFrame = DialPlot.rectangleByRadius(frame, this.outerRadius, this.outerRadius);
        Arc2D.Double inner = new Arc2D.Double(innerFrame, this.startAngle, this.extent, 0);
        Arc2D.Double outer = new Arc2D.Double(outerFrame, this.startAngle + this.extent, -this.extent, 0);
        GeneralPath p = new GeneralPath();
        Point2D point1 = inner.getStartPoint();
        p.moveTo((float)point1.getX(), (float)point1.getY());
        p.append(inner, true);
        p.append(outer, true);
        p.closePath();
        return p;
    }

    protected Shape getOuterWindow(Rectangle2D frame) {
        double radiusMargin = 0.02;
        double angleMargin = 1.5;
        Rectangle2D innerFrame = DialPlot.rectangleByRadius(frame, this.innerRadius - radiusMargin, this.innerRadius - radiusMargin);
        Rectangle2D outerFrame = DialPlot.rectangleByRadius(frame, this.outerRadius + radiusMargin, this.outerRadius + radiusMargin);
        Arc2D.Double inner = new Arc2D.Double(innerFrame, this.startAngle - angleMargin, this.extent + 2.0 * angleMargin, 0);
        Arc2D.Double outer = new Arc2D.Double(outerFrame, this.startAngle + angleMargin + this.extent, -this.extent - 2.0 * angleMargin, 0);
        GeneralPath p = new GeneralPath();
        Point2D point1 = inner.getStartPoint();
        p.moveTo((float)point1.getX(), (float)point1.getY());
        p.append(inner, true);
        p.append(outer, true);
        p.closePath();
        return p;
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Shape window = this.getWindow(frame);
        Shape outerWindow = this.getOuterWindow(frame);
        Area area1 = new Area(outerWindow);
        Area area2 = new Area(window);
        area1.subtract(area2);
        g2.setPaint(Color.lightGray);
        g2.fill(area1);
        g2.setStroke(this.stroke);
        g2.setPaint(this.foregroundPaint);
        g2.draw(window);
        g2.draw(outerWindow);
    }

    public boolean isClippedToWindow() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardDialFrame)) {
            return false;
        }
        StandardDialFrame that = (StandardDialFrame)obj;
        if (!PaintUtilities.equal((Paint)this.backgroundPaint, (Paint)that.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.foregroundPaint, (Paint)that.foregroundPaint)) {
            return false;
        }
        if (this.startAngle != that.startAngle) {
            return false;
        }
        if (this.extent != that.extent) {
            return false;
        }
        if (this.innerRadius != that.innerRadius) {
            return false;
        }
        if (this.outerRadius != that.outerRadius) {
            return false;
        }
        return this.stroke.equals(that.stroke);
    }

    public int hashCode() {
        int result = 193;
        long temp = Double.doubleToLongBits(this.startAngle);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.extent);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.innerRadius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.outerRadius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        result = 37 * result + HashUtilities.hashCodeForPaint((Paint)this.backgroundPaint);
        result = 37 * result + HashUtilities.hashCodeForPaint((Paint)this.foregroundPaint);
        result = 37 * result + this.stroke.hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.foregroundPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.foregroundPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)stream);
    }
}

