/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HideSeriesDemo2
extends ApplicationFrame {
    public HideSeriesDemo2(String string) {
        super(string);
        this.setContentPane(new DemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        HideSeriesDemo2 hideSeriesDemo2 = new HideSeriesDemo2("Hide Series Demo 2");
        hideSeriesDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)hideSeriesDemo2));
        hideSeriesDemo2.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ActionListener {
        private CategoryItemRenderer renderer;

        public DemoPanel() {
            super(new BorderLayout());
            CategoryDataset categoryDataset = this.createSampleDataset();
            JFreeChart jFreeChart = this.createChart(categoryDataset);
            ChartPanel chartPanel = new ChartPanel(jFreeChart);
            JPanel jPanel = new JPanel();
            JCheckBox jCheckBox = new JCheckBox("Series 1");
            jCheckBox.setActionCommand("S1");
            jCheckBox.addActionListener(this);
            jCheckBox.setSelected(true);
            JCheckBox jCheckBox2 = new JCheckBox("Series 2");
            jCheckBox2.setActionCommand("S2");
            jCheckBox2.addActionListener(this);
            jCheckBox2.setSelected(true);
            JCheckBox jCheckBox3 = new JCheckBox("Series 3");
            jCheckBox3.setActionCommand("S3");
            jCheckBox3.addActionListener(this);
            jCheckBox3.setSelected(true);
            jPanel.add(jCheckBox);
            jPanel.add(jCheckBox2);
            jPanel.add(jCheckBox3);
            this.add(chartPanel);
            this.add((Component)jPanel, "South");
            chartPanel.setPreferredSize(new Dimension(500, 270));
        }

        private CategoryDataset createSampleDataset() {
            DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
            defaultCategoryDataset.addValue(3.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
            defaultCategoryDataset.addValue(4.4, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
            defaultCategoryDataset.addValue(1.7, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
            defaultCategoryDataset.addValue(7.3, (Comparable)((Object)"S2"), (Comparable)((Object)"C1"));
            defaultCategoryDataset.addValue(6.4, (Comparable)((Object)"S2"), (Comparable)((Object)"C2"));
            defaultCategoryDataset.addValue(5.7, (Comparable)((Object)"S2"), (Comparable)((Object)"C3"));
            defaultCategoryDataset.addValue(10.3, (Comparable)((Object)"S3"), (Comparable)((Object)"C1"));
            defaultCategoryDataset.addValue(11.4, (Comparable)((Object)"S3"), (Comparable)((Object)"C2"));
            defaultCategoryDataset.addValue(7.7, (Comparable)((Object)"S3"), (Comparable)((Object)"C3"));
            return defaultCategoryDataset;
        }

        private JFreeChart createChart(CategoryDataset categoryDataset) {
            JFreeChart jFreeChart = ChartFactory.createAreaChart("Hide Series Demo 2", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            categoryPlot.setRenderer(new StatisticalLineAndShapeRenderer());
            categoryPlot.setForegroundAlpha(0.5f);
            this.renderer = categoryPlot.getRenderer(0);
            return jFreeChart;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            if (actionEvent.getActionCommand().equals("S1")) {
                n = 0;
            } else if (actionEvent.getActionCommand().equals("S2")) {
                n = 1;
            } else if (actionEvent.getActionCommand().equals("S3")) {
                n = 2;
            }
            if (n >= 0) {
                boolean bl = this.renderer.getItemVisible(n, 0);
                this.renderer.setSeriesVisible(n, new Boolean(!bl));
            }
        }
    }
}

