/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class DeviationRendererDemo1
extends ApplicationFrame {
    public DeviationRendererDemo1(String string) {
        super(string);
        JPanel jPanel = DeviationRendererDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static XYDataset createDataset() {
        YIntervalSeries yIntervalSeries = new YIntervalSeries((Comparable)((Object)"Series 1"));
        YIntervalSeries yIntervalSeries2 = new YIntervalSeries((Comparable)((Object)"Series 2"));
        double d = 100.0;
        double d2 = 100.0;
        for (int i = 0; i <= 100; ++i) {
            d = d + Math.random() - 0.48;
            double d3 = 0.05 * (double)i;
            yIntervalSeries.add(i, d, d - d3, d + d3);
            d2 = d2 + Math.random() - 0.5;
            double d4 = 0.07 * (double)i;
            yIntervalSeries2.add(i, d2, d2 - d4, d2 + d4);
        }
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries(yIntervalSeries);
        yIntervalSeriesCollection.addSeries(yIntervalSeries2);
        return yIntervalSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("DeviationRenderer - Demo 1", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesStroke(1, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesFillPaint(0, new Color(255, 200, 200));
        deviationRenderer.setSeriesFillPaint(1, new Color(200, 200, 255));
        xYPlot.setRenderer(deviationRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = DeviationRendererDemo1.createChart(DeviationRendererDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        DeviationRendererDemo1 deviationRendererDemo1 = new DeviationRendererDemo1("JFreeChart : DeviationRendererDemo1");
        deviationRendererDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)deviationRendererDemo1));
        deviationRendererDemo1.setVisible(true);
    }
}

