import java.io.*;

public class PipedIOExample{
    public static void main(String [] args){
      try{
        PipedReader pipeIn = new PipedReader();
        PipedWriter pipeOut = new PipedWriter(pipeIn);
        new SendThread(pipeOut);
        new ReceiveThread(pipeIn);
      }
      catch (IOException exc){
        exc.printStackTrace();
      }
    }
}
class BaseThread implements Runnable{
    private Thread runner;
    public BaseThread(){
        runner = new Thread(this);
        runner.start();
    }
    public void run(){}
}
class SendThread extends BaseThread{
    private PipedWriter pipeOut;
    public SendThread(PipedWriter pw){
        pipeOut = pw;
    }
    public void run(){
        String outStr = "Tekst";
        try{
          pipeOut.write(outStr);
          pipeOut.flush();
          System.out.println("Napisano: " + outStr);
        }
        catch (IOException exc){
          exc.printStackTrace();
        }
    }
}
class ReceiveThread extends BaseThread{
    private PipedReader pipeIn;
    public ReceiveThread(PipedReader pr){
        pipeIn = pr;
    }
    public void run(){
        char [] buffer = new char[256];
        try{
          pipeIn.read(buffer);
          System.out.println("Odczytano: " + new String(buffer));
        }
        catch (IOException exc){
          exc.printStackTrace();
        }
    }
}

