import java.util.logging.*;
import java.io.*;
public class DistLoggingSender{
    public static void main(String [] args){
        DistLoggingSender app = new DistLoggingSender();
        try{
            app.logTest();
        }
        catch (IOException exc){
            exc.printStackTrace();
        }
    }
    public void logTest() throws IOException{
        LogManager manager = LogManager.getLogManager();
        Logger networkLogger = Logger.getLogger("netlog");
        networkLogger.addHandler(new SocketHandler("localhost", 5280));
        networkLogger.addHandler(new ConsoleHandler());
        testLogger(Level.FINE, "Zaczynamy zapis do dziennika.");
        testLogger(Level.WARNING, "Ostrzeenie!");
    }
    public void testLogger(Level level, String message){
        LogManager manager = LogManager.getLogManager();
        Logger networkLog = manager.getLogger("netlog");
        networkLog.log(level, message);
    }
}