import java.util.*;

public class ProducerThread implements Runnable {
    private ThreadGroup consumers;
    private Thread runner;
    private boolean shutdown;
    private ArrayList tasks;

    public ProducerThread(ThreadGroup msgConsumers) {
        msgConsumers.checkAccess();
        consumers = msgConsumers;
        tasks = new ArrayList();
        runner = new Thread(this);
        runner.start();
    }
    public void shutdown() {
        shutdown = true;
    }
    public synchronized void addTask(Task t) {
        if (t != null) {
            tasks.add(t);
        }
    }
    public synchronized Task removeTask() {
        Task rtnTask = null;
        if (!tasks.isEmpty()) {
            rtnTask = (Task) tasks.remove(0);
        }
        return rtnTask;
    }
    private boolean hasTasks() {
        return tasks.isEmpty();
    }
    public void run() {
        while (!shutdown) {
            if (hasTasks()) {
                consumers.interrupt();
            }
            try {
                Thread.sleep(1000);
            } catch (InterruptedException exc) {
            }
        }
    }
}