import java.io.*;
import java.util.*;

public class CustomLogger{
    private static final String DEFAULT_FILE = "exceptions.log";
    private static final String FILE_KEY = "application.logfile";
    private static CustomLogger instance = new CustomLogger();
    private PrintWriter outputLog;
    private CustomLogger(){
      String filename = System.getProperty(FILE_KEY, DEFAULT_FILE);
      try{
        outputLog = new PrintWriter(new FileWriter(filename, true));
      }
      catch (IOException exc){
        exc.printStackTrace();
      }
    }
    public static CustomLogger getInstance(){
      return instance;
    }
    public void log(String message){
      logMessage(new Date() + "  " + message);
    }
    public void log(Throwable error){
      StringBuffer message = new StringBuffer(new Date() + 
        " BD: " + error.getClass().getName() + 
        System.getProperty("line.separator"));
      message.append(error);
      logMessage(message.toString());
    }
    private void logMessage(String message){
        outputLog.println(message);
        outputLog.flush();
    }
}
