
import javax.naming.*;
import java.rmi.*;
import javax.sql.*;
import java.sql.*;

public class DataSourceServiceLocator {
    private Context context;
    private DataSource source;
    private String dataSourceName;

    private void lookupDS() throws LocatorException {
        try {
            if (context == null) {
                lookupContext();
            }
            source = (DataSource) context.lookup(dataSourceName);
        } catch (NamingException exc) {
            throw new LocatorException(
                    "Problem z obsug JNDI. " + 
                    "Brak poaczenia z usug nazw",
                    exc);
        } catch (ClassCastException exc) {
            throw new LocatorException(
                    "Niemoliwa konwersja do DataSource", exc);
        }
    }

    private void lookupContext() throws NamingException {
        context = new InitialContext();
    }

    public DataSourceServiceLocator() {
        try {
            lookupContext();
        } catch (NamingException exc) {
        }
    }

    public Connection getConnection() throws LocatorException {
        Connection connection = null;
        try {
            lookupDS();
            connection = source.getConnection();
        } catch (SQLException exc) {
            throw new LocatorException(
                    "Bd w uzyskaniu poczenia", exc);
        }
        return connection;
    }

    public void setDataSourceName(String n) {
        dataSourceName = n;
    }
}