import java.net.*;
import java.math.*;
import java.rmi.*;
public class PaymentProxy implements PaymentService {
    private Payment implementation;
    private String serviceMachine = "localhost";
    private String serviceName = "paymentService";
    public PaymentProxy() throws ServiceUnavailableException {
        lookupRemoteService();
    }
    private void lookupRemoteService() throws ServiceUnavailableException {
        try {
            String url = "//" + serviceMachine + "/" + serviceName;
            Object lookup = Naming.lookup(url);
            if (lookup instanceof Payment) {
                implementation = (Payment) lookup;
            } else {
                throw new ServiceUnavailableException(
                        "Niemoliwy dostp do zdalnej usugi");
            }
        } catch (RemoteException exc) {
            throw new ServiceUnavailableException(
                    "Bd podczas wyszukiwania usugi", exc);
        } catch (NotBoundException exc) {
            throw new ServiceUnavailableException(
                    "Nie istnieje zarejestrowana usuga o podanej nazwie", exc);
        } catch (MalformedURLException exc) {
            throw new ServiceUnavailableException(
                    "Niepoprawnie podany adres URL", exc);
        }
    }
    public void setServiceMachine(String machineName) {
        serviceMachine = machineName;
    }
    public void setServiceName(String svcName) {
        serviceName = svcName;
    }
    public void purchase(PaymentVO pay, BigDecimal price)
            throws PaymentException, ServiceUnavailableException {
        try {
            if (implementation != null) {
                implementation.purchase(pay, price);
            }
        } catch (RemoteException exc) {
            try {
                lookupRemoteService();
                implementation.purchase(pay, price);
            } catch (RemoteException exc2) {
                throw new PaymentException(
                        "Niemoliwa realizacja patnoci, problemy z komunikacj",
                        exc2);
            }
        }
    }
}
