import java.util.*;

public class ExceptionObservable{
    private ArrayList observers;
    private BusinessService bizService;
    
    public void addObserver(ExceptionObserver obs){
        observers.add(obs);
    }
    
    public void removeObserver(ExceptionObserver obs){
        observers.remove(obs);
    }
    
    public void setBusinessService(BusinessService svc){
        bizService = svc;
    }
    
    public void businessMethod(){
        try{
            bizService.businessOperation();
        }
        catch (Throwable th){
            Iterator iterate = observers.iterator();
            while (iterate.hasNext()){
                ((ExceptionObserver)iterate.next()).handleException(th);
            }
        }
    }
    
}