import java.util.*;
public class HandlerComposite implements HandlerComponent{
    private ArrayList components = new ArrayList();
    
    public void addComponent(HandlerComponent comp){
        components.add(comp);
    }
    public void removeComponent(HandlerComponent comp){
        components.remove(comp);
    }
    
    public boolean isHealthy(){
        Iterator iterator = components.iterator();
        while (iterator.hasNext()){
            if (!((HandlerComponent)iterator.next()).isHealthy()){
                return false;
            }
        }
        return true;
    }
    
    public void stop(){
        Iterator iterator = components.iterator();
        while (iterator.hasNext()){
            ((HandlerComponent)iterator.next()).stop();
        }
    }
    
    public void start(){
        Iterator iterator = components.iterator();
        while (iterator.hasNext()){
            ((HandlerComponent)iterator.next()).start();
        }
    }
}