import java.sql.*;
import javax.sql.*;
import javax.naming.*;

public class DataSourceConnectionBuilder implements ConnectionBuilder {
    private DataSource dataSce;
    private String dataSourceName;

    public Connection getConnection() throws BuilderException {
        Connection connection = null;
        if (dataSce == null) {
            dataSce = lookUpDataSource();
        }
        try {
            connection = dataSce.getConnection();
        } catch (SQLException exc) {
            throw new BuilderException(
                    "Obiekt DataSource nie udostpni poczenia", exc);
        }
        return connection;
    }

    public void setDataSourceName(String n) {
        dataSourceName = n;
    }

    private DataSource lookUpDataSource() throws BuilderException {
        DataSource sce = null;
        if ((dataSourceName == null) || (dataSourceName.equals(""))) {
            throw new BuilderException(
                    "Brak nazwy szukanego obiektu DataSource");
        }
        try {
            Context ctx = new InitialContext();
            sce = (DataSource) ctx.lookup(dataSourceName);
        } catch (NamingException exc) {
            throw new BuilderException("Nie udao si znale rda danych "
                    + dataSourceName, exc);
        } catch (ClassCastException exc) {
            throw new BuilderException(
                    "Problemy z rzutowaniem znalezionego obiektu "
                            + dataSourceName, exc);
        }
        return sce;
    }
}
