import java.sql.*;
import javax.naming.*;
import javax.sql.*;

public class CustomerDAO{
    private DataSource dataSce;
    private String dsName = "java:comp/env/jdbc/DBSource";
    
    public CustomerDAO(){
        try{
            Context ctx = new InitialContext();
            dataSce = (DataSource)ctx.lookup(dsName);
        }
        catch (NamingException exc){
            
        }
        catch (ClassCastException exc){
            
        }
    }
    
    public CustomerVO getCustomer(String cid) throws SQLException{
        CustomerVO rtnVal = new CustomerVO();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;

        try{
            conn = dataSce.getConnection();
            ps = conn.prepareStatement("SELECT * FROM Customer WHERE cid = ?");
            ps.setString(1, cid);
            rs = ps.executeQuery();
            if (rs.next()){
                rtnVal.setName(rs.getString(1));
                rtnVal.setId(cid);
            }
        }
        finally{
            close(rs, ps, conn);
        }
        return rtnVal;
    }
    
    public void updateCustomer(CustomerVO cust) throws SQLException{
        Connection conn = null;
        PreparedStatement ps = null;
        try{
            conn = dataSce.getConnection();
            ps = conn.prepareStatement("UPDATE Customer SET name = ? WHERE cid = ?");
            ps.setString(1, cust.getName());
            ps.setString(2, cust.getId());
            ps.executeUpdate();
        }
        finally{
            close(null, ps, conn);
        }
    }
    
    private void close(ResultSet rs, Statement stmt, Connection conn){
        if (rs != null){
            try{
                rs.close();
            }
            catch (SQLException exc){}
        }
        if (stmt != null){
            try{
                stmt.close();
            }
            catch (SQLException exc){}
        }
        if (conn != null){
            try{
                conn.close();
            }
            catch (SQLException exc){}
        }
    }
}