import java.io.*;
import java.nio.*;
import java.nio.channels.*;
public class ReadFile{
    private FileChannel inFileChannel;
    private WritableByteChannel stdOutChannel;
    private ByteBuffer inBuffer;
    public static void main(String [] args){
        if (args.length > 0){
            ReadFile app = new ReadFile();
            app.openFileIn(args[0]);
        }
    }
    public void openFileIn(String fileName){
        try{
            inFileChannel = new FileInputStream(fileName).getChannel();
            stdOutChannel = Channels.newChannel(System.out);
            inBuffer = ByteBuffer.allocate((int)inFileChannel.size());
            inFileChannel.read(inBuffer);
            inBuffer.rewind();
            stdOutChannel.write(inBuffer);
            stdOutChannel.close();
            inFileChannel.close();
        }
        catch(IOException exc){
            exc.printStackTrace();
        }
    }
}