import java.util.logging.*;
import java.io.*;
public class MultiLogging{
    public static void main(String [] args){
        MultiLogging app = new MultiLogging();
        try{
            app.logTest();
        }
        catch (IOException exc){
            exc.printStackTrace();
        }
    }
    public void logTest() throws IOException{
        LogManager manager = LogManager.getLogManager();
        Logger standardLogger = Logger.getLogger("base.log");
        Logger fileLogger = Logger.getLogger("base.log.file");
        // Gdy standardLogger jest skonfigurowany jako rodzic
        // obiektu fileLogger, wszystkie komunikaty wysyane do obiektu
        // potomnego trafi rwnie do obiektu-rodzica
        //
        // Jest to przydatne w momencie, gdy zdarzenia s przekazywane dalej
        // tworzc w ten sposb acuch komunikatw
        
        standardLogger.setLevel(Level.SEVERE);
        fileLogger.addHandler(new FileHandler("ProblemLog.log", true));
        fileLogger.setLevel(Level.INFO);
        manager.addLogger(standardLogger);
        manager.addLogger(fileLogger);
        testLoggers(Level.INFO, "Ta informacja ma charakter neutralny.");
        testLoggers(Level.SEVERE, "Zdarzya si rzecz straszna. Moesz si ju zacz ba.");
    }
    public void testLoggers(Level level, String message){
        LogManager manager = LogManager.getLogManager();
        Logger specialLog = manager.getLogger("base.log.file");
        specialLog.log(level, message);
    }
}
