import java.io.*;
import java.util.*;
import java.util.logging.*;

public class Defaults{
  private static final String ALTERNATE_HOST = "denver";
  private static final int ALTERNATE_PORT = 5280;
  private static final String HOST_KEY = "client.app.host";
  private static final String PORT_KEY = "client.app.port";
  private ClientNetwork communication;
  
  public void sendData(String host, int port, Serializable information){
    if (communication == null){
      communication = new ClientNetwork();
      try{
        communication.connect(host, port);
        communication.sendData(information);
      }
      catch (IOException exc){
        if (!host.equals(ALTERNATE_HOST) && !(port == ALTERNATE_PORT)){
          sendData(ALTERNATE_HOST, ALTERNATE_PORT, information);
        }
      }
    }
  }
  
  public void sendData(String host, int port, 
          Serializable information, String propertyFile){
    if (communication == null){
      communication = new ClientNetwork();
    }
    try{
      communication.connect(host, port);
      communication.sendData(information);
    }
    catch (IOException exc){
      Logger.global.warning("Bd wejcia-wyjcia: nastpi prba uycia wartoci alternatywnych");
      Properties serverProps = new Properties();
      try{
        FileInputStream input = new FileInputStream(propertyFile);
        serverProps.load(input);
        String serverName = serverProps.getProperty(HOST_KEY, ALTERNATE_HOST);
        sendData(serverName, port, information);
      }
      catch (IOException exc2){
        Logger.global.severe("Kolejny bd poczenia z serwerem: generujemy IOException");
        exc.printStackTrace();
      }
    }
  }
  
  public static void main(String [] args){
    Defaults app = new Defaults();
    app.sendData("localhost", 2001, new Date(), "server.properties");
  }
}