public class OrderFacade {
    private InventoryService invSvc;
    private PaymentService paySvc;
    private ShippingService shipSvc;
    public OrderFacade() {
        invSvc = new InventoryService();
        paySvc = new PaymentService();
        shipSvc = new ShippingService();
    }
    public void placeOrder(Customer c, Order o) throws OrderException {
        boolean result;
        try {
            invSvc.reserveOrderItems(o);
            if (o.isComplete()) {
                paySvc.purchaseOrder(c, o);
                shipSvc.shipOrder(o);
            }
        } catch (InventoryException e) {
            throw new OrderException(
                    "Niemoliwa rezerwacja pozycji zamwienia", o, c, e);
        } catch (PaymentException e) {
            try {
                invSvc.cancelReservedItems(o);
                throw new OrderException(
                        "Problem z patnoci, zamwienie wycofane", o, c, e);
            } catch (InventoryException ex2) {
                throw new OrderException(
                        "Konieczne rczne wycofanie zamwienia", o, c, e);
            }
        }
    }
}
