import java.sql.*;

public class CustomerDAOAdapter{
    private CustomerDAO adaptee;
    
    public CustomerDAOAdapter(){
        adaptee = new CustomerDAO();
    }
    
    public CustomerVO lookUpCustomer(String id) throws CustomerException{
        CustomerVO rtnValue = null;
        try{
            rtnValue = adaptee.getCustomer(id);
        }
        catch (SQLException exc){
            throw new CustomerException("Nie mona znale klienta", exc);
        }
        return rtnValue;
    }
    
    public void updateCustomer(CustomerVO cust) throws CustomerException{
        try{
            adaptee.updateCustomer(cust);
        }
        catch (SQLException exc){
            throw new CustomerException("Nie mona zmieni danych klienta", exc);
        }
    }
}

