/*
 *  Uwaga! Wynaga JDK1.5 
 *
 *  javac -source 1.5 SimpleList.java
 *
 */

public class SimpleList<E> {
    private static final int INIT_SIZE = 20;
    private transient E[] items;
    private transient int size;
    public SimpleList(){
        this(INIT_SIZE);
    }
    public SimpleList(int capacity){
        if (capacity <= 0){
            capacity = INIT_SIZE;
        }
        items = (E [])new Object[capacity];
    }
    public void add(E item){
        if (size >= items.length){
            growList();
        }
        items[size++] = item;
    }

    public E get(int idx){
        if ((idx < 0) || (idx > items.length)){
            throw new IndexOutOfBoundsException(idx + " nieprawidowy indeks dla SimpleList");
        }
        else if (items[idx] == null){
            throw new NullPointerException("Pusty element SimpleList");
        }
        return items[idx];
    }
    public String toString(){
        StringBuffer contents = new StringBuffer("[ ");
        for (int i = 0; i < size; i++){
            contents.append(items[i].toString());
            contents.append(" ");
        }
        contents.append("]");
        return contents.toString();
    }
    private void growList(){
        E[] newItems = (E [])new Object[2 * items.length];
        System.arraycopy(items, 0, newItems, 0, items.length);
        items = newItems;
    }
}