import java.util.logging.*;

public class HandlerThreadGroup extends ThreadGroup {
    public HandlerThreadGroup(String name) {
        super(name);
    }
    public HandlerThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }
    public void uncaughtException(Thread t, Throwable e) {
        System.out.println("Wtek " + t
                + " zgosi nastpujcy wyjtek: " + e);
        e.printStackTrace(System.err);
    }
    public static void main(String[] args) {
        HandlerThreadGroup newGroup = new HandlerThreadGroup("testGroup");
        TestThread tt;
        for (int i = 0; i < 10; i++) {
            tt = new TestThread(newGroup);
            if (Math.random() > 0.75) {
                tt.haltThread();
            }
        }
    }
    static class TestThread implements Runnable {
        private Thread runner;
        private boolean halt;

        public TestThread(ThreadGroup group) {
            runner = new Thread(group, this);
            runner.start();
        }
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000);
                } catch (InterruptedException exc) {
                }
                if (halt)
                    throw new RuntimeException(
                            "Przyrywamy wtek!");
            }
        }
        public void haltThread() {
            halt = true;
        }
    }
}