import java.util.Locale;
import java.util.ResourceBundle;
public class LocalizedException extends Exception{
    public static final String DEFAULT_MESSAGE_KEY = "criticalException";
    private String localeMessageKey = DEFAULT_MESSAGE_KEY;
    private String languageCode;
    private String countryCode;
    
    public LocalizedException(String message){
        super(message);
    }
    public LocalizedException(Throwable cause, String messageKey){
        super(cause);
        if (isValidString(messageKey)){
            localeMessageKey = messageKey;
        }
    }
    public LocalizedException(String defaultMessage, Throwable cause, String messageKey){
        super(defaultMessage, cause);
        if (isValidString(messageKey)){
            localeMessageKey = messageKey;
        }
    }
    public LocalizedException(String defaultMessage, String messageKey, String language, String country){
        super(defaultMessage);
        if (isValidString(messageKey)){
            localeMessageKey = messageKey;
        }
        if (isValidString(country)){
            countryCode = country;
        }
        if (isValidString(language)){
            languageCode = language;
        }
    }
    
    public void setLocaleMessageKey(String messageKey){
        if (isValidString(messageKey)){
            localeMessageKey = messageKey;
        }
    }
    public String getLocaleMessageKey(){
        return localeMessageKey;
    }
    
    public String getLocalizedMessage(){
        ResourceBundle rb = null;
        Locale locale = getLocale();
        rb = ResourceBundle.getBundle("ExceptionResourceBundle", locale);
        return rb.getString(localeMessageKey);
    }
    
    private Locale getLocale(){
        Locale locale = Locale.getDefault();
        if ((languageCode != null) && (countryCode != null)){
            locale = new Locale(languageCode, countryCode); 
        }
        else if (languageCode != null){
            locale = new Locale(languageCode);
        }
        return locale;
    }
    
    private boolean isValidString(String input){
        return (input != null) && (!input.equals(""));
    }
}