public class ServerManager{
    private CommunicationServer commoServer = new CommunicationServerImpl();
    private boolean shutdown;
    
    public ServerManager(CommunicationServer svr){
        commoServer = svr;
    }
    
    public void setShutdown(){
        shutdown = true;
    }
    
    public void initialize(int port){
        try{
            commoServer.connect(port);
        }
        catch (ServerConnectionException exc){
        }
    }
    
    public void handlerCycle(){
        while (!shutdown){
            commoServer.listen();
            try{
                commoServer.processClient();
            }
            catch (ServerConnectionException exc){
                logError("Bd poczenia " + exc.getClient(), exc);
            }
        }
    }
    
    private void logError(String message, Throwable exception){
    
    }
}