import java.lang.reflect.*;
import java.io.*;
import java.nio.channels.*;

public class Reflect{
    private String className;
    
    public static void main(String [] args){
        if (args.length >= 1){
            Reflect app = new Reflect();
            app.setClassName(args[0]);
            app.printMethods(System.out);
        }
        else{
            Reflect app = new Reflect();
            try{
                app.printMethods(DatagramChannel.open().getClass(), System.out);
            }
            catch (IOException exc){
            }
        }
    }
    public void setClassName(String name){
        className = name;
    }

    public void printMethods(PrintStream ps){
        try{
            Class reflectClass = Class.forName(className);
            Method [] methods = reflectClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; i++){
                ps.println(methods[i]);
            }
        }
        catch (ClassNotFoundException e){
            System.err.println("Niemoliwe znalezienie klasy " + className);
        }
        catch (NullPointerException e){
            System.err.println("Warto null okrelajca nazw klasy");
        }
    }

    public void printMethods(Class cl, PrintStream ps){
        Method [] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++){
            ps.println(methods[i]);
        }
    }
}