package r14.r14_02;

import java.io.StringReader;

/*
Pobierz archiwa JAR Rhino i silnika Rhino ze stron 
https://mvnrepository.com/artifact/org.mozilla/rhino
https://mvnrepository.com/artifact/org.mozilla/rhino-engine
Umieść je w katalogu
Ustaw do tego katalogu zmienną środowiskową RHINO_HOME

javac r14/r14_02/ScriptEngineDemo.java
java --classpath .:$RHINO_HOME/\* r14.r14_02.ScriptEngineDemo
 
*/

import java.io.StringWriter;

import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;


public class ScriptEngineDemo {
    public static void main(String[] args) throws ScriptException, NoSuchMethodException {
        var manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("javascript");
        String scriptString = "6 * 8";
        Object wynik = engine.eval(scriptString);
        System.out.println(wynik);
        
        engine.eval("n = 1728");
        wynik = engine.eval("n + 1");
        System.out.println(wynik);
        
        System.out.println(engine.getFactory().getParameter("THREADING"));
        
        engine.put("k", 1728);
        wynik = engine.eval("k + 1");
        System.out.println(wynik);
        engine.eval("n = 1728");
        wynik = engine.get("n");
        System.out.println(wynik);
        
        Bindings scope = engine.createBindings();
        scope.put("m", 1728);
        wynik = engine.eval("m + 1", scope);
        System.out.println(wynik);
        
        // Metoda setReader nie działa z Rhino
        var reader = new StringReader("Franek");
        engine.getContext().setReader(reader);
        engine.eval("""
java.lang.System.out.print('Wpisz swoje imię: ')        		
name = new java.util.Scanner(java.lang.System.in).nextLine();  
java.lang.System.out.println('Witaj, ' + name)        		
""");
        System.out.println("Czy powiedziałem \"witaj\" Frankowi, czy Tobie?");

        // Metoda setWriter nie działa z Rhino
        var writer = new StringWriter();
        engine.getContext().setWriter(writer);
        engine.eval("print('Witaj'); java.lang.System.out.println('świecie')");
        System.out.println("writer.toString(): " + writer.toString());
	    
        engine.eval("function pozdrowienie(jak, kto) { return jak + ', ' + kto + '!' }");
        wynik = ((Invocable) engine).invokeFunction("pozdrowienie", "Witaj", "świecie");
        System.out.println(wynik);

        engine.eval("function Pozdrawiacz(jak) { this.jak = jak }");
        engine.eval("""
Pozdrawiacz.prototype.welcome = function(kto) { 
  return this.jak + ', ' + kto + '!' 
}""");
        Object yo = engine.eval("new Pozdrawiacz('Yo')");
        wynik = ((Invocable) engine).invokeMethod(yo, "welcome", "świecie");
        System.out.println(wynik);

        engine.eval("function welcome(kto) { return 'Witaj, ' + kto + '!' }");
        Pozdrawiacz g1 = ((Invocable) engine).getInterface(Pozdrawiacz.class);
        wynik = g1.welcome("świecie");
        System.out.println(wynik);
        
        Pozdrawiacz g2 = ((Invocable) engine).getInterface(yo, Pozdrawiacz.class);
        wynik = g2.welcome("świecie");
        System.out.println(wynik);
        
        JSON json = ((Invocable) engine).getInterface(engine.eval("JSON"), JSON.class);
        wynik = json.parse("{\"name\": \"Franek\", \"age\": 40}");
        System.out.println(wynik);
        wynik = json.stringify(wynik);
        System.out.println(wynik);
    }

    public interface Pozdrawiacz {
        String welcome(String kto);
    }
    
    public interface JSON {
        Object parse(String str);
        String stringify(Object obj);
    }    
}
