package r09.r09_02;

import java.nio.file.Path;

public class PathDemo {
    public static void main(String[] args) {
        Path absolute = Path.of("/", "home", "cay");
        Path relative = Path.of("myprog", "conf", "user.properties");
        System.out.println(absolute);
        System.out.println(relative);
        Path katalogDomowy = Path.of("/home/cay");
        System.out.println(katalogDomowy);
        
        Path katalogRoboczy  = katalogDomowy.resolve("myprog/work");
        System.out.println(katalogRoboczy);
        Path tempPath = katalogRoboczy.resolveSibling("temp");
        System.out.println(tempPath);
        
        relative = Path.of("/home/cay").relativize(Path.of("/home/fred/myprog"));
        System.out.println(relative);
        
        Path normalized = Path.of("/home/cay/../fred/./myprog").normalize();
        System.out.println(" ścieżka znormalizowana: " + normalized);
        
        absolute = Path.of("config").toAbsolutePath();
        System.out.println("ścieżka bezwzględna: " + absolute);
        
        Path p = Path.of("/home", "cay", "myprog.properties");
        System.out.println("p: " + p);
        Path parent = p.getParent(); 
        System.out.println("katalog nadrzędny dla p: " + parent);
        Path file = p.getFileName(); 
        System.out.println("nazwa pliku p: " + file);
        Path root = p.getRoot(); 
        System.out.println("katalog głowny dla p: " + root);
        Path first = p.getName(0);
        System.out.println("pierwszy element ścieżki do p: " + first);
        Path dir = p.subpath(0, p.getNameCount() - 1);
        System.out.println("ścieżka katalogu z plikiem p: " + dir);
        
        System.out.println("Składniki ścieżki do pliku p");
        for (Path component : p) {
            System.out.println(component);
        }
    }
}
