package r06.r06_04;

import java.util.ArrayList;
import java.util.function.Predicate;

public class Employees {
    public static void printNames(ArrayList<? extends Employee> staff) {
        for (int i = 0; i < staff.size(); i++) {
            Employee e = staff.get(i);
            System.out.println(e.getName());
        }
    }
    
    public static void wyświetlWszystko1(Employee[] staff, Predicate<Employee> filter) {
        for (Employee e : staff) 
            if (filter.test(e))
                System.out.println(e.getName());
    }

    public static void wyświetlWszystko2(Employee[] staff, Predicate<? super Employee> filter) {
        for (Employee e : staff) 
            if (filter.test(e))
                System.out.println(e.getName());
    }
    
    public static void main(String[] args) {
        Employee[] pracownicy = {
          new Employee("Fred", 50000),
          new Employee("Wilma", 60000),
        };
        wyświetlWszystko1(pracownicy, e -> e.getSalary() > 100000);
        wyświetlWszystko2(pracownicy, e -> e.getSalary() > 100000);
        Predicate<Object> evenLength = e -> e.toString().length() % 2 == 0; 
        // wyświetlWszystko1(pracownicy, evenLength);
        wyświetlWszystko2(pracownicy, evenLength);
    }
}
