package r12.r12_02;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;

public class LocalDates {
    public static void main(String[] args) {
        LocalDate today = LocalDate.now(); // // Bieżąca data
        System.out.println("dziś: " + today);

        LocalDate urodzinyAlonzo = LocalDate.of(1903, 6, 14);
        urodzinyAlonzo = LocalDate.of(1903, Month.JUNE, 14);
        // Korzysta z typu wyliczeniowego Month
        System.out.println("urodzinyAlonzo: " + urodzinyAlonzo);

        LocalDate dzieńProgramisty = LocalDate.of(2014, 1, 1).plusDays(255);
        // 13 września, ale w roku przestępnym 12 września
        System.out.println("dzieńProgramisty: " + dzieńProgramisty);

        LocalDate dzieńNiepodległości = LocalDate.of(2014, Month.JULY, 4);
        LocalDate BożeNarodzenie = LocalDate.of(2014, Month.DECEMBER, 25);

        System.out.println("Do Bożego Narodzenia: " + dzieńNiepodległości.until(BożeNarodzenie));
        System.out.println("Do Bożego Narodzenia: " + dzieńNiepodległości.until(BożeNarodzenie, ChronoUnit.DAYS));

        System.out.println(LocalDate.of(2016, 1, 31).plusMonths(1));
        System.out.println(LocalDate.of(2016, 3, 31).minusMonths(1));

        DayOfWeek startOfLastMillennium = LocalDate.of(1900, 1, 1).getDayOfWeek();
        System.out.println("początekZeszłegoWieku: " + startOfLastMillennium);
        System.out.println(startOfLastMillennium.getValue());
        System.out.println(DayOfWeek.SATURDAY.plus(3));
        
        Stream<LocalDate> allDaysInMay2018
        	= LocalDate.of(2018,5,1).datesUntil(LocalDate.of(2018,6,1));
        Stream<LocalDate> allMondaysIn2018
        	= LocalDate.of(2018,1,1).datesUntil(LocalDate.of(2019,1,1), Period.ofDays(7));
        System.out.println("Wszystkie dni w maju 2018 r.: " + allDaysInMay2018.toList());
        System.out.println("Wszystkie poniedziałki w 2018 r.: " + allMondaysIn2018.toList());
    }
}
