package r12.r12_01;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.random.RandomGenerator;
import java.util.stream.IntStream;

public class Timeline {
    public static void main(String[] args) {
        Instant start = Instant.now();
        uruchomAlgorytm();
        Instant koniec = Instant.now();
        Duration zmierzonyCzas = Duration.between(start, koniec);
        long millis = zmierzonyCzas.toMillis();
        System.out.printf("%d milisekund\n", millis);

        Instant start2 = Instant.now();
        uruchomAlgorytm2();
        Instant koniec2 = Instant.now();
        Duration zmierzonyCzas2 = Duration.between(start2, koniec2);
        System.out.printf("%d milisekund\n", zmierzonyCzas2.toMillis());
        boolean overTenTimesFaster = zmierzonyCzas.multipliedBy(10).minus(zmierzonyCzas2).isNegative();
        System.out.printf("Pierwszy algorytm jest %swięcej niż dziesięć razy szybszy",
                overTenTimesFaster ? "" : "nie ");
    }

    private static RandomGenerator generator = RandomGenerator.getDefault();

    public static void uruchomAlgorytm() {
        int size = 10;
        List<Integer> list = generator.ints()
        		.map(i -> i % 100)
        		.limit(size)
        		.boxed()
        		.toList();
        Collections.sort(list);
        System.out.println(list);
    }

    public static void uruchomAlgorytm2() {
        int size = 10;
        List<Integer> list = generator.ints()
        		.map(i -> i % 100)
        		.limit(size)
        		.boxed()
        		.toList();
        while (!IntStream.range(1, list.size()).allMatch(
                i -> list.get(i - 1).compareTo(list.get(i)) <= 0))
            Collections.shuffle(list);
        System.out.println(list);
    }
}
