package r09.r09_04;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class RemovingOrReplacingMatches {
    public static void main(String[] args) {
        Pattern przecinki = Pattern.compile("\\s*,\\s*");
        CharSequence input = "Piotr , Paweł,  Maria";
        String[] tokens = przecinki.split(input);
        System.out.println(Arrays.toString(tokens));
        
        Stream<String> tokenStream = przecinki.splitAsStream(input);
        System.out.println(tokenStream.toList());
        
        Matcher matcher = przecinki.matcher(input);
        String result = matcher.replaceAll(",");
        System.out.println(result);
        
        Pattern time = Pattern.compile("(\\d{1,2}):(\\d{2})");
        matcher = time.matcher("3:45");
        result = matcher.replaceAll("$1 godziny i $2 minut");
        System.out.println(result);
        
        result = "3:45".replaceAll(
                "(?<godziny>\\d{1,2}):(?<minut>\\d{2})", 
                "${godziny} godziny i ${minut} minut");
        System.out.println(result);        
    }
}
