package r09.r09_01;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CharsetDemo {
    public static void main(String[] args) {
        System.out.println("Domyślny zestaw znaków na tym komputerze: " + Charset.defaultCharset());
        System.out.println("Zestawy znaków dostępne w JVM: " + Charset.availableCharsets().keySet());
        
        String str = "Java\u2122";
        System.out.println(str);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        showBytes(bytes);
            // Zauważ, żę oznaczenie marki chronionej zajmuje trzy bajty
        showBytes(str.getBytes(StandardCharsets.UTF_16));
            // Zauważ znacznik kolejności bajtów
        showBytes(str.getBytes(StandardCharsets.ISO_8859_1));
            // Znak TM nie może być zakodowany i jest zastępowany znakiem ?
        
        System.out.println(new String(bytes, Charset.forName("windows-1252")));
            // Skąd wiesz, że to złe kodowanie? Jak może to stwierdzić program?
    }
    
    public static void showBytes(byte[] bytes) {
        for (byte b : bytes) System.out.printf("%2X ", b);
        System.out.println();
    }
}
