package r08.r08_09;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

record Person(int id, String nazwisko) {}

public class CollectingIntoMaps {

    public static Stream<Person> people() {
        return Stream.of(new Person(1001, "Nowak"), new Person(1002, "Kowalski"), new Person(1003,
                "Wiśniewska"));
    }

    public static void main(String[] args) throws IOException {
        Map<Integer, String> idNaNazwisko = people().collect(
                Collectors.toMap(Person::id, Person::nazwisko));
        System.out.println("idNaNazwisko: " + idNaNazwisko);

        Map<Integer, Person> idNaOsobę = people().collect(
                Collectors.toMap(Person::id, Function.identity()));
        System.out.println("idNaOsobę: " + idNaOsobę.getClass().getName() + idNaOsobę);

        idNaOsobę = people().collect(
                Collectors.toMap(Person::id, Function.identity(), (existingValue, newValue) -> {
                    throw new IllegalStateException();
                }, TreeMap::new));

        System.out.println("idNaOsobę: " + idNaOsobę.getClass().getName() + idNaOsobę);

        Stream<Locale> locales = Stream.of(Locale.getAvailableLocales());
        Map<String, String> nazwyJęzyków = locales.collect(Collectors.toMap(
                Locale::getDisplayLanguage, 
                loc -> loc.getDisplayLanguage(loc),
                (existingValue, newValue) -> existingValue));
        System.out.println("nazwyJęzyków: " + nazwyJęzyków);

        locales = Stream.of(Locale.getAvailableLocales());
        Map<String, Set<String>> zestawyJęzykówDlaKrajów = locales.collect(
                Collectors.toMap(
                        Locale::getDisplayCountry, 
                        l -> Collections.singleton(l.getDisplayLanguage()),
                        (a, b) -> { // Połączenie a i b
                            var union = new HashSet<String>(a);
                            union.addAll(b);
                            return union;
                }));
        System.out.println("zestawyJęzykówDlaKrajów: " + zestawyJęzykówDlaKrajów);
    }
}
