package r04.r04_03;

import java.util.Objects;

public class Item {
    private String description;
    private double price;
        
    public Item(String description, double price) {
        this.description = description;
        this.price = price;
    }

    public boolean equals(Object otherObject) {
        // Szybkie sprawdzenie, czy obiekty są identyczne
        if (this == otherObject) return true;
        // Musi zwrócić false, jeśli argumentem jest null
        if (otherObject == null) return false;
        // Sprawdzenie, czy otherObject jest klasy Item
        if (getClass() != otherObject.getClass()) return false;
        // Sprawdzenie, czy zmienne instancji mają identyczne wartości
        var other = (Item) otherObject;
        return Objects.equals(description, other.description)
            && price == other.price;
    }
    
    public int hashCode() {
        return Objects.hash(description, price);
    }
}
