package r10.r10_08;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadLocalDemo {
    public static final NumberFormat sharedFormatter 
        = NumberFormat.getCurrencyInstance(); // ŹLE
    public static final ThreadLocal<NumberFormat> currencyFormat 
        = ThreadLocal.withInitial(() -> NumberFormat.getCurrencyInstance()); // DOBRZE
    
    public static String asCurrency(double value) {
        NumberFormat formatter = currencyFormat.get();
        // formatter = sharedFormatter
        // Spróbuj zmienić i zobacz, co się stanie...
        return formatter.format(value);
    }
    
    public static void main(String[] args) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newCachedThreadPool();
        var tasks = new ArrayList<Callable<String>>();
        for (int i = 1; i < 100; i++) {        
            double value = 1000.01 * i;;
            tasks.add(() -> asCurrency(value));
        }
        List<Future<String>> result = executor.invokeAll(tasks);
        for (Future<String> f : result) 
            System.out.println(f.get());
    }
}
