package r09.r09_04;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Groups {
    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("(\\p{Alnum}+(\\s+\\p{Alnum}+)*)\\s+([A-Z]{3})([0-9.]*)");
        String input = "Granatowy Blender    PLN29.95";
        Matcher matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String nazwa = matcher.group(1);
            String waluta = matcher.group(3);
            String cena = matcher.group(4);
            System.out.printf("nazwa=%s,waluta=%s,cena=%s\n", nazwa, waluta, cena);
        }
        
        pattern = Pattern.compile("(\\p{Alnum}+(?:\\s+\\p{Alnum}+)*)\\s+([A-Z]{3})([0-9.]*)");
        matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String nazwa = matcher.group(1);
            String waluta = matcher.group(2);
            String cena = matcher.group(3);
            System.out.printf("nazwa=%s,waluta=%s,cena=%s\n", nazwa, waluta, cena);
        }
        
        pattern = Pattern.compile("(?<nazwa>\\p{Alnum}+(\\s+\\p{Alnum}+)*)\\s+(?<waluta>[A-Z]{3})(?<cena>[0-9.]*)");
        matcher = pattern.matcher(input);
        if (matcher.matches()) {
            String nazwa = matcher.group("nazwa");
            String waluta = matcher.group("waluta");
            String cena = matcher.group("cena");
            System.out.printf("nazwa=%s,waluta=%s,cena=%s\n", nazwa, waluta, cena);
        }        
    }
}
