package r05.r05_03;

/*
javac r05/r05_03/LoggingDemo.java
java -Djava.util.logging.config.file=logging.properties r05.r05_03.LoggingDemo

 */

import static java.lang.System.Logger.Level.*;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;

public class LoggingDemo {
    public static void main(String[] args) {
    	System.Logger logger = System.getLogger("com.mojafirma.mojaaplikacja");
    	logger.log(System.Logger.Level.INFO, "Uruchamianie programu");
    	
    	// Pomiń wyznaczanie treści nierejestrowanego komunikatu. 
    	logger.log(INFO, () -> "Argumenty " + Arrays.toString(args));
    	
    	// Rejestrowanie wyjątków
    	String nazwaPliku = "fred.txt";
    	try {    		
    		System.out.println(Files.readString(Path.of(nazwaPliku)));    		
    	} catch (IOException ex) {
    		logger.log(WARNING, "Nie można otworzyć pliku {0}", nazwaPliku);
    	}    	
    }
}
