package com.horstmann.hello;

/*

Skompiluj moduł usługi: 

javac com.horstmann.greetsvc/module-info.java \
   com.horstmann.greetsvc/com/horstmann/greetsvc/GreeterService.java \
   com.horstmann.greetsvc/com/horstmann/greetsvc/internal/*.java \
   -encoding UTF-8
   
Skompiluj i uruchom ten program:
   
javac -p com.horstmann.greetsvc \
   r15.r15_13/com/horstmann/hello/HelloWorld.java \
   r15.r15_13/module-info.java -encoding UTF-8
java -p com.horstmann.greetsvc:r15.r15_13 \
   -m r15.r15_13/com.horstmann.hello.HelloWorld de    

(w systemie Windows zamiast : musi być ;)
 */

import com.horstmann.greetsvc.GreeterService;
import java.util.Locale;
import java.util.ServiceLoader;

public class HelloWorld {
    public static void main(String[] args) {
        ServiceLoader<GreeterService> greeterLoader
            = ServiceLoader.load(GreeterService.class);
        GreeterService chosenGreeter = null;
        for (GreeterService greeter : greeterLoader) {
            if (args.length > 0 &&
                  greeter.getLocale().getLanguage().equals(args[0]))
               chosenGreeter = greeter;
        }
        if (chosenGreeter == null)
           System.out.println("Brak odpowiedniego pozdrowienia. Spróbuj z de, fr lub pl.");
        else
           System.out.println(chosenGreeter.greet("Modular World"));
    }
}
