package r10.r10_05;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CHMDemo {
    public static ConcurrentHashMap<String, Long> mapa = new ConcurrentHashMap<>();

    public static void process(Path path) {
        try {
            String contents = Files.readString(path);
            for (String słowo : contents.split("\\PL+")) {
                mapa.merge(słowo, 1L, Long::sum);
                // albo mapa.compute(słowo, (k, v) -> v == null ? 1 : v + 1);
                /* albo
                mapa.putIfAbsent(słowo, 0L);
                Long staraWartość, nowaWartość;
                do {
                    staraWartość = mapa.get(słowo);
                    nowaWartość = staraWartość + 1;
                } while (!mapa.replace(słowo, staraWartość, nowaWartość));                                
                */
                /* ale nie
                Long staraWartość = mapa.get(słowo);
                Long nowaWartość = staraWartość == null ? 1 : staraWartość + 1;
                mapa.put(słowo, nowaWartość); // Błąd — może nie zastąpić staraWartość                                
                */
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
    
    public static Set<Path> descendants(Path p) throws IOException {        
        try (Stream<Path> entries = Files.walk(p)) {
            return entries.filter(Files::isRegularFile).collect(Collectors.toSet());
        }
    }
    
    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException {
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(processors);
        Path pathToRoot = Path.of(".");
        for (Path p : descendants(pathToRoot)) {
            executor.execute(() -> process(p));
        }        
        executor.shutdown();
        executor.awaitTermination(10, TimeUnit.MINUTES);
        System.out.println(mapa);
    }
}
